/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.poi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.nkjmlab.sorm4j.internal.util.ParameterizedStringUtils;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.util.java.time.DateTimeUtils;

public class ExcelUtils {
    /*
     * Enabled aggressive exception aggregation
     */
    public static List<String> readAllRows(File file, String sheetName, String cellSeparatorAfterConverted, String cellQuoteStringAfterConverted, String nullStringAfterConverted) {
        try (FileInputStream in = new FileInputStream(file);){
            ArrayList<String> arrayList;
            block13: {
                Workbook wb = WorkbookFactory.create((InputStream)in);
                try {
                    Sheet sheet = wb.getSheet(sheetName);
                    ArrayList<String> allRows = new ArrayList<String>();
                    sheet.forEach(row -> {
                        ArrayList convertedCells = new ArrayList();
                        row.forEach(cell -> {
                            String val = ExcelUtils.getStringValue(cell);
                            convertedCells.add(cellQuoteStringAfterConverted + (val == null || val.equals("null") ? nullStringAfterConverted : val) + cellQuoteStringAfterConverted);
                        });
                        allRows.add(String.join((CharSequence)cellSeparatorAfterConverted, convertedCells));
                    });
                    arrayList = allRows;
                    if (wb == null) break block13;
                }
                catch (Throwable throwable) {
                    if (wb != null) {
                        try {
                            wb.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                wb.close();
            }
            return arrayList;
        }
        catch (IOException | EncryptedDocumentException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public static Map<String, Integer> getColumnNames(Sheet sheet) {
        Row r = sheet.getRow(0);
        HashMap<String, Integer> columnNames = new HashMap<String, Integer>();
        for (int i = 0; i < r.getLastCellNum(); ++i) {
            columnNames.put(r.getCell(i).toString(), i);
        }
        return columnNames;
    }

    public static String getStringValue(Cell cell) {
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    return DateTimeUtils.toTimestamp((Date)cell.getDateCellValue()).toString();
                }
                return Double.toString(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return ExcelUtils.getStringFormulaValue(cell);
            }
            case BLANK: {
                return ExcelUtils.getStringRangeValue(cell);
            }
        }
        return null;
    }

    public static String getStringFormulaValue(Cell cell) {
        Workbook book = cell.getSheet().getWorkbook();
        CreationHelper helper = book.getCreationHelper();
        FormulaEvaluator evaluator = helper.createFormulaEvaluator();
        CellValue value = evaluator.evaluate(cell);
        switch (value.getCellType()) {
            case STRING: {
                return value.getStringValue();
            }
            case NUMERIC: {
                return Double.toString(value.getNumberValue());
            }
            case BOOLEAN: {
                return Boolean.toString(value.getBooleanValue());
            }
        }
        throw new IllegalArgumentException(ParameterizedStringUtils.newString((String)"{} is invalid", (Object[])new Object[]{cell}));
    }

    public static String getStringCachedFormulaValue(Cell cell) {
        switch (cell.getCachedFormulaResultType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                return Double.toString(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
        }
        throw new IllegalArgumentException(ParameterizedStringUtils.newString((String)"{} is invalid", (Object[])new Object[]{cell}));
    }

    public static String getStringRangeValue(Cell cell) {
        int rowIndex = cell.getRowIndex();
        int columnIndex = cell.getColumnIndex();
        Sheet sheet = cell.getSheet();
        int size = sheet.getNumMergedRegions();
        for (int i = 0; i < size; ++i) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            if (!range.isInRange(rowIndex, columnIndex)) continue;
            Cell firstCell = ExcelUtils.getCell(sheet, range.getFirstRow(), range.getFirstColumn());
            return ExcelUtils.getStringValue(firstCell);
        }
        return null;
    }

    public static Cell getCell(Sheet sheet, int rowIndex, int columnIndex) {
        Row row = sheet.getRow(rowIndex);
        if (row != null) {
            Cell cell = row.getCell(columnIndex);
            return cell;
        }
        return null;
    }
}

