/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.firebase.auth;

import jakarta.servlet.http.HttpServletRequest;
import org.nkjmlab.util.firebase.auth.FirebaseAuthRpcService;
import org.nkjmlab.util.firebase.auth.FirebaseAuthService;
import org.nkjmlab.util.firebase.auth.FirebaseSigninSession;

public class BasicFirebaseAuthRpcService
implements FirebaseAuthRpcService {
    private final FirebaseAuthService firebaseAuthService;
    private final HttpServletRequest request;

    private BasicFirebaseAuthRpcService(FirebaseAuthService firebaseAuthService, HttpServletRequest request) {
        this.firebaseAuthService = firebaseAuthService;
        this.request = request;
    }

    @Override
    public boolean isSigninToFirebase() {
        return this.firebaseAuthService.isSignin(this.request.getSession().getId());
    }

    @Override
    public FirebaseSigninSession signinWithFirebase(String idToken) {
        return this.firebaseAuthService.signin(this.request.getSession().getId(), idToken).orElse(null);
    }

    @Override
    public boolean signout() {
        return this.firebaseAuthService.signout(this.request.getSession().getId());
    }

    public static class Factory {
        private final FirebaseAuthService firebaseAuthService;

        public Factory(FirebaseAuthService firebaseAuthService) {
            this.firebaseAuthService = firebaseAuthService;
        }

        public BasicFirebaseAuthRpcService create(HttpServletRequest request) {
            return new BasicFirebaseAuthRpcService(this.firebaseAuthService, request);
        }
    }
}

