/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.firebase.auth;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.nkjmlab.util.firebase.auth.FirebaseAuthHandler;
import org.nkjmlab.util.java.function.Try;

public class BasicFirebaseAuthHandler
implements FirebaseAuthHandler {
    private final Set<String> acceptableEmails;
    private final FirebaseAuth firebaseAuth;

    public BasicFirebaseAuthHandler(Collection<String> acceptableEmails, ServiceAccountCredentials credentials) {
        FirebaseOptions options = FirebaseOptions.builder().setCredentials((GoogleCredentials)credentials).build();
        FirebaseApp firebaseApp = FirebaseApp.initializeApp((FirebaseOptions)options);
        this.firebaseAuth = FirebaseAuth.getInstance((FirebaseApp)firebaseApp);
        this.acceptableEmails = new HashSet<String>(acceptableEmails);
    }

    @Override
    public Optional<FirebaseToken> isAcceptableIdToken(String idToken) {
        if (idToken == null || idToken.length() == 0) {
            return Optional.empty();
        }
        try {
            FirebaseToken verifiedToken = this.firebaseAuth.verifyIdToken(idToken);
            if (!verifiedToken.isEmailVerified()) {
                return Optional.empty();
            }
            String email = verifiedToken.getEmail();
            if (!this.acceptableEmails.contains(email)) {
                return Optional.empty();
            }
            return Optional.of(verifiedToken);
        }
        catch (FirebaseAuthException e) {
            return Optional.empty();
        }
    }

    public static BasicFirebaseAuthHandler create(Collection<String> acceptableEmails, File firebaseServiceAccountJson) {
        BasicFirebaseAuthHandler basicFirebaseAuthHandler;
        FileInputStream serviceAccount = new FileInputStream(firebaseServiceAccountJson);
        try {
            ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)serviceAccount);
            basicFirebaseAuthHandler = new BasicFirebaseAuthHandler(acceptableEmails, credentials);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)serviceAccount).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw Try.rethrow((Throwable)e);
            }
        }
        ((InputStream)serviceAccount).close();
        return basicFirebaseAuthHandler;
    }
}

