/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.jakarta.websocket;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.CloseReason;
import jakarta.websocket.OnClose;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import java.util.function.BiConsumer;

@ClientEndpoint
public class WebsocketClientEndpoint {
    private final MessagePassingQueue.Consumer<Session> onOpenHandler;
    private final BiConsumer<String, Session> onMessageHandler;
    private final BiConsumer<CloseReason, Session> onCloseHandler;
    private final BiConsumer<Throwable, Session> onErrorHandler;

    public WebsocketClientEndpoint(MessagePassingQueue.Consumer<Session> onOpenHandler, BiConsumer<String, Session> onMessageHandler, BiConsumer<CloseReason, Session> onCloseHandler, BiConsumer<Throwable, Session> onErrorHandler) {
        this.onOpenHandler = onOpenHandler;
        this.onMessageHandler = onMessageHandler;
        this.onCloseHandler = onCloseHandler;
        this.onErrorHandler = onErrorHandler;
    }

    @OnOpen
    public void onOpen(Session session) {
        this.onOpenHandler.accept((Object)session);
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        this.onMessageHandler.accept(message, session);
    }

    @OnClose
    public void onClose(CloseReason closeReason, Session session) {
        this.onCloseHandler.accept(closeReason, session);
    }

    @OnError
    public void onError(Throwable th, Session session) {
        this.onErrorHandler.accept(th, session);
    }
}

