/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.jakarta.websocket;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import jakarta.websocket.CloseReason;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Session;
import java.io.IOException;
import java.net.URI;
import java.util.function.BiConsumer;
import org.nkjmlab.util.jakarta.websocket.WebsocketClientEndpoint;
import org.nkjmlab.util.java.function.Try;
import org.nkjmlab.util.java.lang.StringFormatter;
import org.nkjmlab.util.java.logging.LogManager;
import org.nkjmlab.util.java.logging.SimpleLogger;
import org.nkjmlab.util.java.net.UriUtils;

public class WebsocketClientSession {
    private static final SimpleLogger log = LogManager.createLogger();
    private final Session session;

    public static Builder builder(String uri) {
        return new Builder(uri);
    }

    public void close() {
        try {
            this.session.close();
        }
        catch (IOException e) {
            log.error(e.getMessage(), new Object[0]);
        }
    }

    public void sendMessage(String message) {
        try {
            this.session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public String toString() {
        return "WebsocketClient [session=" + this.session + "]";
    }

    public Session getSession() {
        return this.session;
    }

    private WebsocketClientSession(Session session) {
        this.session = session;
    }

    public static class Builder {
        private MessagePassingQueue.Consumer<Session> onOpenHandler = session -> log.debug("onOpen={}", new Object[]{session});
        private BiConsumer<String, Session> onMessageHandler = (message, session) -> log.debug("[{}] onMessage {}", new Object[]{session.getId(), message});
        private BiConsumer<CloseReason, Session> onCloseHandler = (closeReason, session) -> {
            log.debug("[{}] onClose {}", new Object[]{session.getId(), closeReason});
            try {
                session.close();
            }
            catch (IOException e) {
                log.error((Throwable)e, (Throwable)e);
            }
        };
        private BiConsumer<Throwable, Session> onErrorHandler = (th, session) -> log.debug("[{}] onError {}", new Object[]{session.getId(), th});
        private URI uri;

        private Builder(String uri) {
            this.uri = UriUtils.of((String)uri);
        }

        public void setOnOpenHandler(MessagePassingQueue.Consumer<Session> onOpenHandler) {
            this.onOpenHandler = onOpenHandler;
        }

        public void setOnMessageHandler(BiConsumer<String, Session> onMessageHandler) {
            this.onMessageHandler = onMessageHandler;
        }

        public void setOnCloseHandler(BiConsumer<CloseReason, Session> onCloseHandler) {
            this.onCloseHandler = onCloseHandler;
        }

        public void setOnErrorHandler(BiConsumer<Throwable, Session> onErrorHandler) {
            this.onErrorHandler = onErrorHandler;
        }

        public WebsocketClientSession open() {
            try {
                WebsocketClientEndpoint endpoint = new WebsocketClientEndpoint(this.onOpenHandler, this.onMessageHandler, this.onCloseHandler, this.onErrorHandler);
                Session session = ContainerProvider.getWebSocketContainer().connectToServer((Object)endpoint, this.uri);
                if (session.isOpen()) {
                    log.debug("[{}] session is open to {}", new Object[]{session.getId(), this.uri});
                }
                return new WebsocketClientSession(session);
            }
            catch (DeploymentException | IOException e) {
                log.error(StringFormatter.format((String)"error occurs {}", (Object[])new Object[]{this.uri}), new Object[]{e});
                throw Try.rethrow((Throwable)e);
            }
        }
    }
}

