/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.thymeleaf;

import java.util.ArrayList;
import java.util.List;
import org.nkjmlab.util.thymeleaf.ThymeleafTemplateResolverBuilder;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafTemplateEngineBuilder {
    private final ThymeleafTemplateResolverBuilder templateResolverBuilder = ThymeleafTemplateResolverBuilder.builder();
    private final List<IDialect> dialects = new ArrayList<IDialect>();

    public static ThymeleafTemplateEngineBuilder builder() {
        return new ThymeleafTemplateEngineBuilder();
    }

    public ThymeleafTemplateEngineBuilder setPrefix(String prefix) {
        this.templateResolverBuilder.setPrefix(prefix);
        return this;
    }

    public ThymeleafTemplateEngineBuilder setSuffix(String suffix) {
        this.templateResolverBuilder.setSuffix(suffix);
        return this;
    }

    public ThymeleafTemplateEngineBuilder setTtlMs(long cacheTtlMs) {
        this.templateResolverBuilder.setCacheTtlMs(cacheTtlMs);
        return this;
    }

    public ThymeleafTemplateEngineBuilder setTemplateResolver(AbstractConfigurableTemplateResolver templateResolver) {
        this.templateResolverBuilder.setTemplateResolver(templateResolver);
        return this;
    }

    public ThymeleafTemplateEngineBuilder addDialect(IDialect dialect) {
        this.dialects.add(dialect);
        return this;
    }

    public TemplateEngine build() {
        TemplateEngine engine = new TemplateEngine();
        engine.setTemplateResolver((ITemplateResolver)this.templateResolverBuilder.build());
        this.dialects.forEach(d -> engine.addDialect(d));
        return engine;
    }
}

