/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.commons.math3;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.IteratorUtils;

public class Frequency<T extends Comparable<T>> {
    private Class<T> clazz;
    private org.apache.commons.math3.stat.Frequency freq = new org.apache.commons.math3.stat.Frequency();

    public static void main(String[] args) {
        Frequency<Object> freq = Frequency.createIntegerFrequency();
        freq.addValue(1);
        freq.addValue(2);
        freq.addValue(1);
        freq.addValue(1);
        freq.addValue(3);
        System.out.println(freq.getCount(1));
        System.out.println(freq.getCount(2));
        System.out.println(freq.getCount(3));
        System.out.println("---");
        freq = Frequency.createStringFrequency();
        freq.addValue((Integer)((Object)"s"));
        freq.addValue("u");
        freq.addValue("u");
        freq.addValue("t");
        System.out.println(freq.getCount("S"));
        System.out.println(freq.getCount("s"));
        System.out.println(freq.getCount("u"));
    }

    public Frequency(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void merge(Frequency<T> other) {
        this.freq.merge(other.getFreq());
    }

    public org.apache.commons.math3.stat.Frequency getFreq() {
        return this.freq;
    }

    public void addValue(T v) {
        this.freq.addValue(v);
    }

    public long getCount(T v) {
        return this.freq.getCount(v);
    }

    public static Frequency<Integer> createIntegerFrequency() {
        return new Frequency<Integer>(Integer.class);
    }

    public static Frequency<String> createStringFrequency() {
        return new Frequency<String>(String.class);
    }

    public List<Map.Entry<T, Long>> entrySet() {
        HashMap map = new HashMap();
        List list = IteratorUtils.toList((Iterator)this.freq.entrySetIterator());
        list.forEach(e -> {
            Comparable key = (Comparable)e.getKey();
            if (this.clazz.isAssignableFrom(Integer.class) && key instanceof Long) {
                map.put(((Long)key).intValue(), (Long)e.getValue());
            } else {
                map.put(key, (Long)e.getValue());
            }
        });
        List<Map.Entry<T, Long>> result = map.entrySet().stream().sorted(Comparator.comparing(e -> (Comparable)e.getKey())).collect(Collectors.toList());
        return result;
    }

    public String toString() {
        return "Frequency [clazz=" + this.clazz + ", freq=" + this.freq + "]";
    }
}

