/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.jfreechart;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.nkjmlab.util.jfreechart.ChartBuilder;

public class CategoryDatasetChartBuilder
extends ChartBuilder {
    private DefaultCategoryDataset dataset = new DefaultCategoryDataset();
    private String categoryAxisLabel = "x";
    private String valueAxisLabel = "y";
    private ChartType type = ChartType.LINE_CHART;

    public void addValue(Number value, Comparable<?> rowKey, Comparable<?> columnKey) {
        this.dataset.addValue(value, rowKey, columnKey);
    }

    public void setLabel(String graphTitle, String categoryAxisLabel, String valueAxisLabel) {
        this.graphTitle = graphTitle;
        this.categoryAxisLabel = categoryAxisLabel;
        this.valueAxisLabel = valueAxisLabel;
    }

    public void setType(ChartType type) {
        this.type = type;
    }

    public JFreeChart build() {
        return this.createChart(this.type);
    }

    public JFreeChart createChart(ChartType type) {
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        switch (type) {
            case LINE_CHART: {
                return ChartFactory.createLineChart((String)this.graphTitle, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case AREA_CHART: {
                return ChartFactory.createAreaChart((String)this.graphTitle, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case BAR_CAHRT: {
                return ChartFactory.createBarChart((String)this.graphTitle, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case STACKED_AREA_CHART: {
                return ChartFactory.createStackedAreaChart((String)this.graphTitle, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
            case STACKED_BAR_CHART: {
                return ChartFactory.createStackedBarChart((String)this.graphTitle, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
            }
        }
        return ChartFactory.createLineChart((String)this.graphTitle, (String)this.categoryAxisLabel, (String)this.valueAxisLabel, (CategoryDataset)this.dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
    }

    public static enum ChartType {
        LINE_CHART,
        AREA_CHART,
        BAR_CAHRT,
        BAR_CHART_3D,
        STACKED_AREA_CHART,
        STACKED_BAR_CHART;

    }
}

