/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.jfreechart;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.Title;
import org.jfree.data.Range;
import org.jfree.data.xy.DefaultXYDataset;
import org.jfree.data.xy.XYDataset;
import org.nkjmlab.util.jfreechart.ChartBuilder;
import org.nkjmlab.util.jfreechart.ChartUtils;

public class XYDatasetChartBuilder
extends ChartBuilder {
    private Map<Integer, DefaultXYDataset> datasets = new HashMap<Integer, DefaultXYDataset>();
    private Map<Integer, XYItemRenderer> datasetRenderers = new HashMap<Integer, XYItemRenderer>();
    private String xAxisLabel = "x";
    private String yAxisLabel = "y";
    private ChartType type = ChartType.SCATTER_PLOT;
    private Range xRange;
    private Range yRange;
    private boolean legend = true;
    private List<Title> subtitles = new ArrayList<Title>();

    public static void main(String[] args) {
        XYDatasetChartBuilder chartBuilder = new XYDatasetChartBuilder();
        chartBuilder.addSeries((Comparable<?>)((Object)"hoge"), new int[][]{{1, 2, 10}, {4, 5, 6}});
        chartBuilder.setType(ChartType.XY_LINE_CHART);
        JFreeChart chart = chartBuilder.build();
        ChartUtils.viewInFrame(chart, "hoge", 0, 0, 500, 500);
    }

    public void addRenderer(XYItemRenderer renderer) {
        this.datasetRenderers.put(0, renderer);
    }

    public void addRenderer(int datasetId, XYItemRenderer renderer) {
        this.datasetRenderers.put(datasetId, renderer);
    }

    public void addSeries(Comparable<?> seriesKey, int[][] data) {
        this.addSeries(0, seriesKey, data);
    }

    public void addSeries(int datasetId, Comparable<?> seriesKey, int[][] data) {
        this.datasets.computeIfAbsent(datasetId, key -> new DefaultXYDataset());
        double[][] tmp = new double[data.length][data[0].length];
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[0].length; ++j) {
                tmp[i][j] = data[i][j];
            }
        }
        this.datasets.get(datasetId).addSeries(seriesKey, tmp);
    }

    public void addSeries(Comparable<?> seriesKey, double[][] data) {
        this.addSeries(0, seriesKey, data);
    }

    public void addSeries(int datasetId, Comparable<?> seriesKey, double[][] data) {
        this.datasets.computeIfAbsent(datasetId, key -> new DefaultXYDataset());
        this.datasets.get(datasetId).addSeries(seriesKey, data);
    }

    public void setLabels(String graphTitle, String xAxisLabel, String yAxisLabel, Title[] subtitles) {
        this.graphTitle = graphTitle;
        this.xAxisLabel = xAxisLabel;
        this.yAxisLabel = yAxisLabel;
        this.subtitles.addAll(Arrays.asList(subtitles));
    }

    public void setType(ChartType type) {
        this.type = type;
    }

    public JFreeChart build() {
        JFreeChart chart = this.chreateChart(this.type, this.datasets.get(0));
        ArrayList<Integer> keys = new ArrayList<Integer>(this.datasets.keySet());
        Collections.sort(keys);
        XYPlot plot = chart.getXYPlot();
        for (int i = 0; i < keys.size(); ++i) {
            if (i == 0) continue;
            plot.setDataset(i, (XYDataset)this.datasets.get(i));
            plot.setRenderer(i, this.datasetRenderers.getOrDefault(i, (XYItemRenderer)new XYLineAndShapeRenderer()));
        }
        return chart;
    }

    private JFreeChart chreateChart(ChartType type, DefaultXYDataset dataset) {
        JFreeChart chart;
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createLegacyTheme());
        switch (type) {
            case SCATTER_PLOT: {
                chart = ChartFactory.createScatterPlot((String)this.graphTitle, (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.legend, (boolean)true, (boolean)false);
                break;
            }
            case TIME_SERIES_CHART: {
                chart = ChartFactory.createTimeSeriesChart((String)this.graphTitle, (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)dataset, (boolean)this.legend, (boolean)true, (boolean)false);
                break;
            }
            case XY_AREA_CHART: {
                chart = ChartFactory.createXYAreaChart((String)this.graphTitle, (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.legend, (boolean)true, (boolean)false);
                break;
            }
            case XY_LINE_CHART: {
                chart = ChartFactory.createXYLineChart((String)this.graphTitle, (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.legend, (boolean)true, (boolean)false);
                break;
            }
            case XY_STEP_AREA_CHART: {
                chart = ChartFactory.createXYStepAreaChart((String)this.graphTitle, (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.legend, (boolean)true, (boolean)false);
                break;
            }
            case XY_STEP_CHART: {
                chart = ChartFactory.createXYStepChart((String)this.graphTitle, (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.legend, (boolean)true, (boolean)false);
                break;
            }
            default: {
                chart = ChartFactory.createScatterPlot((String)this.graphTitle, (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)this.legend, (boolean)true, (boolean)false);
            }
        }
        if (this.xRange != null) {
            chart.getXYPlot().getDomainAxis().setRange(this.xRange);
        }
        if (this.yRange != null) {
            chart.getXYPlot().getRangeAxis().setRange(this.yRange);
        }
        if (!this.legend) {
            chart.removeLegend();
        }
        chart.setSubtitles(this.subtitles);
        return chart;
    }

    public void removeLegend() {
        this.legend = false;
    }

    public void setXRange(Range xRange) {
        this.xRange = xRange;
    }

    public void setYRange(Range yRange) {
        this.yRange = yRange;
    }

    public static enum ChartType {
        SCATTER_PLOT,
        TIME_SERIES_CHART,
        XY_AREA_CHART,
        XY_LINE_CHART,
        XY_STEP_AREA_CHART,
        XY_STEP_CHART;

    }
}

