/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.javax.mail;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Scanner;
import java.util.stream.Collectors;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.input.CloseShieldInputStream;

public class MailUtils {
    public static String promptToInputPassword(String loginId, String host) {
        System.out.print("$ password for " + loginId + "@" + host + " >");
        try (Scanner s = new Scanner((InputStream)new CloseShieldInputStream(System.in));){
            String str;
            String string = str = s.nextLine();
            return string;
        }
    }

    public static boolean promptYesOrNo(String message) {
        System.out.print(message);
        try (Scanner s = new Scanner((InputStream)new CloseShieldInputStream(System.in));){
            String val;
            switch (val = s.nextLine()) {
                case "y": {
                    boolean bl = true;
                    return bl;
                }
                case "n": {
                    boolean bl = false;
                    return bl;
                }
            }
            System.out.println("input [y or n]");
            boolean bl = MailUtils.promptYesOrNo(message);
            return bl;
        }
    }

    public static String getMailHeader(MimeMessage message) {
        try {
            String from = "from: " + String.join((CharSequence)",", Arrays.stream(message.getFrom()).map(a -> a.toString()).collect(Collectors.toList()));
            String to = "to: " + String.join((CharSequence)",", Arrays.stream(message.getRecipients(MimeMessage.RecipientType.TO)).map(a -> a.toString()).collect(Collectors.toList()));
            String cc = "cc: " + String.join((CharSequence)",", Arrays.stream(message.getRecipients(MimeMessage.RecipientType.CC)).map(a -> a.toString()).collect(Collectors.toList()));
            String bcc = "bcc: " + String.join((CharSequence)",", Arrays.stream(message.getRecipients(MimeMessage.RecipientType.BCC)).map(a -> a.toString()).collect(Collectors.toList()));
            String subject = message.getSubject();
            return String.join((CharSequence)System.lineSeparator(), from, to, cc, bcc, subject);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }
}

