/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.jfreechart;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.nkjmlab.util.jfreechart.ChartBuilder;
import org.nkjmlab.util.jfreechart.ChartUtils;

public class TimeSeriesChartBuilder
extends ChartBuilder {
    private TimeSeriesCollection dataset = new TimeSeriesCollection();
    private String xAxisLabel = "time";
    private String yAxisLabel = "value";
    private ChartType type = ChartType.TIME_SERIES_CHART;

    public static void main(String[] args) {
        TimeSeriesChartBuilder s1 = new TimeSeriesChartBuilder();
        s1.add((Comparable<?>)((Object)"Tweets"), (RegularTimePeriod)new Day(1, 6, 2016), 1.0);
        s1.add((Comparable<?>)((Object)"Tweets"), (RegularTimePeriod)new Day(2, 6, 2016), 3.0);
        s1.add((Comparable<?>)((Object)"Tweets"), (RegularTimePeriod)new Day(3, 6, 2016), 6.0);
        ChartUtils.viewInFrame(s1.build(), "Tweets", 0, 0, 640, 480);
    }

    public void addSeries(TimeSeries series) {
        this.dataset.addSeries(series);
    }

    public void add(Comparable<?> key, RegularTimePeriod period, Number value) {
        this.add(key, period, value.doubleValue());
    }

    public void add(Comparable<?> key, RegularTimePeriod period, double value) {
        if (this.dataset.getSeries(key) == null) {
            this.dataset.addSeries(new TimeSeries(key));
        }
        this.dataset.getSeries(key).add(period, value);
    }

    public JFreeChart build() {
        return this.createChart(this.type);
    }

    public JFreeChart createChart(ChartType type) {
        switch (type) {
            case TIME_SERIES_CHART: {
                return ChartFactory.createTimeSeriesChart((String)this.graphTitle, (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)this.dataset, (boolean)true, (boolean)true, (boolean)false);
            }
        }
        return ChartFactory.createTimeSeriesChart((String)this.graphTitle, (String)this.xAxisLabel, (String)this.yAxisLabel, (XYDataset)this.dataset, (boolean)true, (boolean)true, (boolean)false);
    }

    public static enum ChartType {
        TIME_SERIES_CHART;

    }
}

