/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.firebase.auth;

import com.google.firebase.auth.FirebaseToken;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nkjmlab.util.firebase.auth.BasicFirebaseService;
import org.nkjmlab.util.firebase.auth.FirebaseAccountsTable;
import org.nkjmlab.util.firebase.auth.FirebaseRpcServiceInterface;
import org.nkjmlab.util.firebase.auth.FirebaseSession;

public class FirebaseRpcService
implements FirebaseRpcServiceInterface {
    private static final Logger log = LogManager.getLogger();
    private final BasicFirebaseService firebaseService;
    private final FirebaseAccountsTable firebaseAccountsTable;
    private final HttpServletRequest request;

    public FirebaseRpcService(BasicFirebaseService firebaseService, FirebaseAccountsTable firebaseAccountsTable, HttpServletRequest request) {
        this.firebaseService = firebaseService;
        this.firebaseAccountsTable = firebaseAccountsTable;
        this.request = request;
    }

    @Override
    public boolean isSigninToFirebase() {
        FirebaseSession session = FirebaseSession.wrap(this.request.getSession());
        return session.isSigninFirebase();
    }

    @Override
    public FirebaseAccountsTable.FirebaseAccount signinWithFirebase(String idToken) {
        FirebaseAccountsTable.FirebaseAccount account = this.verifyIdTokenAndGetFirebaseAccount(idToken).orElseThrow();
        FirebaseSession session = FirebaseSession.wrap(this.request.getSession());
        session.signIn(account, 36000);
        return session.getFirebaseAccount().orElseThrow();
    }

    private Optional<FirebaseAccountsTable.FirebaseAccount> verifyIdTokenAndGetFirebaseAccount(String idToken) {
        FirebaseToken firebaseToken = this.firebaseService.verifyIdToken(idToken).orElseThrow();
        FirebaseAccountsTable.FirebaseAccount account = this.firebaseAccountsTable.readByEmail(firebaseToken.getEmail()).orElseThrow();
        return Optional.ofNullable(account);
    }

    @Override
    public boolean signoutFromFirebase() {
        this.request.getSession().invalidate();
        return true;
    }
}

