/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.firebase.auth;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseAuthException;
import com.google.firebase.auth.FirebaseToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.nkjmlab.util.java.function.Try;

public class BasicFirebaseService {
    private final FirebaseAuth firebaseAuth;

    public BasicFirebaseService(File firebaseServiceAccountJson) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream serviceAccount = new FileInputStream(firebaseServiceAccountJson);){
                ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)serviceAccount);
                FirebaseOptions options = FirebaseOptions.builder().setCredentials((GoogleCredentials)credentials).build();
                FirebaseApp firebaseApp = FirebaseApp.initializeApp((FirebaseOptions)options);
                this.firebaseAuth = FirebaseAuth.getInstance((FirebaseApp)firebaseApp);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public Optional<FirebaseToken> verifyIdToken(String idToken) {
        if (idToken == null || idToken.length() == 0) {
            return Optional.empty();
        }
        try {
            FirebaseToken verifiedToken = this.firebaseAuth.verifyIdToken(idToken);
            return verifiedToken.isEmailVerified() ? Optional.of(verifiedToken) : Optional.empty();
        }
        catch (FirebaseAuthException e) {
            return Optional.empty();
        }
    }
}

