/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.firebase.auth;

import jakarta.servlet.http.HttpSession;
import java.util.Optional;
import org.nkjmlab.util.firebase.auth.FirebaseAccountsTable;

public class FirebaseSession {
    private static final String FIREBASE_ACCOUNT = "FIREBASE_ACCOUNT";
    private final HttpSession session;

    public static FirebaseSession wrap(HttpSession session) {
        return new FirebaseSession(session);
    }

    private FirebaseSession(HttpSession session) {
        this.session = session;
    }

    public boolean isSigninFirebase() {
        return this.getFirebaseAccount().isPresent();
    }

    public void signIn(FirebaseAccountsTable.FirebaseAccount firebaseAccount, int intervalSec) {
        this.setAttribute(FIREBASE_ACCOUNT, firebaseAccount);
        this.setMaxInactiveInterval(intervalSec);
    }

    public Optional<FirebaseAccountsTable.FirebaseAccount> getFirebaseAccount() {
        return this.getAttribute(FIREBASE_ACCOUNT).map(o -> (FirebaseAccountsTable.FirebaseAccount)o);
    }

    public Optional<Object> getAttribute(String name) {
        return Optional.ofNullable(this.session.getAttribute(name));
    }

    public String getSessionId() {
        return this.session.getId();
    }

    public HttpSession getSession() {
        return this.session;
    }

    public void invalidate() {
        this.session.invalidate();
    }

    public void setAttribute(String name, Object value) {
        this.session.setAttribute(name, value);
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }
}

