/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.java.logging;

import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.nkjmlab.util.java.lang.MethodInvokerInfoUtils;
import org.nkjmlab.util.java.lang.ParameterizedStringFormatter;
import org.nkjmlab.util.java.logging.SimpleLogger;

public class JulLogger
implements SimpleLogger {
    private static final Logger defaultLogger = JulLogger.createDefaultLogger();
    private final Logger logger;

    private static Logger createDefaultLogger() {
        Logger logger = Logger.getLogger(JulLogger.class.getName());
        logger.setLevel(Level.FINE);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return String.valueOf(this.formatMessage(record)) + System.lineSeparator();
            }
        });
        consoleHandler.setLevel(Level.FINE);
        logger.addHandler(consoleHandler);
        return logger;
    }

    public JulLogger(Logger logger) {
        this.logger = logger;
    }

    public static SimpleLogger getLogger() {
        return new JulLogger(defaultLogger);
    }

    public void trace(String format, Object ... params) {
        this.logger.finer(String.valueOf(MethodInvokerInfoUtils.getInvokerLogMessage((int)3, (String)SimpleLogger.Category.TRACE.name(), (StackTraceElement[])new Throwable().getStackTrace())) + " " + ParameterizedStringFormatter.DEFAULT.format(format, params));
    }

    public void debug(String format, Object ... params) {
        this.logger.fine(String.valueOf(MethodInvokerInfoUtils.getInvokerLogMessage((int)3, (String)SimpleLogger.Category.DEBUG.name(), (StackTraceElement[])new Throwable().getStackTrace())) + " " + ParameterizedStringFormatter.DEFAULT.format(format, params));
    }

    public void info(String format, Object ... params) {
        this.logger.info(String.valueOf(MethodInvokerInfoUtils.getInvokerLogMessage((int)3, (String)SimpleLogger.Category.INFO.name(), (StackTraceElement[])new Throwable().getStackTrace())) + " " + ParameterizedStringFormatter.DEFAULT.format(format, params));
    }

    public void warn(String format, Object ... params) {
        this.logger.warning(String.valueOf(MethodInvokerInfoUtils.getInvokerLogMessage((int)3, (String)SimpleLogger.Category.WARN.name(), (StackTraceElement[])new Throwable().getStackTrace())) + " " + ParameterizedStringFormatter.DEFAULT.format(format, params));
    }

    public void error(String format, Object ... params) {
        this.logger.severe(String.valueOf(MethodInvokerInfoUtils.getInvokerLogMessage((int)3, (String)SimpleLogger.Category.ERROR.name(), (StackTraceElement[])new Throwable().getStackTrace())) + " " + ParameterizedStringFormatter.DEFAULT.format(format, params));
    }

    public void error(Throwable message, Throwable throwable) {
        Object[] params = new Object[]{};
        this.logger.severe(String.valueOf(MethodInvokerInfoUtils.getInvokerLogMessage((int)3, (String)SimpleLogger.Category.ERROR.name(), (StackTraceElement[])new Throwable().getStackTrace())) + " " + ParameterizedStringFormatter.DEFAULT.format(message != null ? message.toString() : ("" + throwable != null ? throwable.toString() : ""), params));
    }

    public void warn(Throwable message, Throwable throwable) {
        Object[] params = new Object[]{};
        this.logger.warning(String.valueOf(MethodInvokerInfoUtils.getInvokerLogMessage((int)3, (String)SimpleLogger.Category.ERROR.name(), (StackTraceElement[])new Throwable().getStackTrace())) + " " + ParameterizedStringFormatter.DEFAULT.format(message != null ? message.toString() : ("" + throwable != null ? throwable.toString() : ""), params));
    }
}

