/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.openai.chat.model;

import java.util.Arrays;
import java.util.List;

public record ChatRequest(String model, Float temperature, Float top_p, Integer n, Integer max_tokens, Float presence_penalty, Float frequency_penalty, String user, List<ChatMessage> messages) {
    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String model = Model.GPT_3_5_TURBO.getValue();
        private Float temperature;
        private Float top_p;
        private Integer n;
        private Integer max_tokens;
        private Float presence_penalty;
        private Float frequency_penalty;
        private String user;
        private List<ChatMessage> messages;

        public Builder model(Model model) {
            this.model = model.getValue();
            return this;
        }

        public Builder messages(ChatMessage ... messages) {
            this.messages = Arrays.asList(messages);
            return this;
        }

        public ChatRequest build() {
            return new ChatRequest(this.model, this.temperature, this.top_p, this.n, this.max_tokens, this.presence_penalty, this.frequency_penalty, this.user, this.messages);
        }
    }

    public record ChatMessage(String role, String content) {
        public static ChatMessage of(Role role, String text) {
            return new ChatMessage(role.getValue(), text);
        }

        public static enum Role {
            USER("user"),
            SYSTEM("system"),
            ASSISTANT("assistant");

            private final String value;

            private Role(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }

            public String toString() {
                return this.getValue();
            }
        }
    }

    public static enum Model {
        GPT_3_5_TURBO("gpt-3.5-turbo"),
        GPT_3_5_TURBO_0301("gpt-3.5-turbo-0301");

        private final String value;

        private Model(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

