/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.poi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.nkjmlab.sorm4j.internal.util.Try;
import org.nkjmlab.util.java.lang.ParameterizedStringFormatter;
import org.nkjmlab.util.java.stream.StreamUtils;
import org.nkjmlab.util.java.time.DateTimeUtils;

public class BasicExcelSheet {
    private final File file;
    private final String sheetName;

    public BasicExcelSheet(File file, String sheetName) {
        this.file = file;
        this.sheetName = sheetName;
    }

    public static Builder builder(File file, String sheetName) {
        return new Builder(file, sheetName);
    }

    /*
     * Loose catch block
     */
    public <T> T procSheet(Function<Sheet, T> sheetFunction) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                T t;
                Workbook wb;
                FileInputStream in;
                block18: {
                    block17: {
                        in = new FileInputStream(this.file);
                        wb = WorkbookFactory.create((InputStream)in);
                        Sheet sheet2 = wb.getSheet(this.sheetName);
                        t = sheetFunction.apply(sheet2);
                        if (wb == null) break block17;
                        wb.close();
                    }
                    if (in == null) break block18;
                    in.close();
                }
                return t;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (wb != null) {
                                wb.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (in != null) {
                                in.close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | EncryptedDocumentException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public List<String> readAllRows(String cellSeparatorAfterConverted, String cellQuoteStringAfterConverted, String nullStringAfterConverted) {
        return this.readAllCells().stream().map(row -> {
            List convertedCells = row.stream().map(cell -> {
                String val = BasicExcelSheet.toStringValue(cell);
                return String.valueOf(cellQuoteStringAfterConverted) + (val == null || val.equals("null") ? nullStringAfterConverted : val) + cellQuoteStringAfterConverted;
            }).collect(Collectors.toList());
            return String.join((CharSequence)cellSeparatorAfterConverted, convertedCells);
        }).collect(Collectors.toList());
    }

    public List<List<Cell>> readAllCells() {
        return this.procSheet(sheet -> StreamUtils.stream((Iterable)sheet).map(row -> StreamUtils.stream((Iterable)row).collect(Collectors.toList())).collect(Collectors.toList()));
    }

    public Map<String, Integer> readFirstRowAsHeader() {
        return this.procSheet(sheet -> {
            Row r = sheet.getRow(0);
            HashMap<String, Integer> columnNames = new HashMap<String, Integer>();
            int i = 0;
            while (i < r.getLastCellNum()) {
                columnNames.put(r.getCell(i).toString(), i);
                ++i;
            }
            return columnNames;
        });
    }

    public Cell readCell(int rowIndex, int columnIndex) {
        return this.procSheet(sheet -> BasicExcelSheet.readCell(sheet, rowIndex, columnIndex));
    }

    public static Cell readCell(Sheet sheet, int rowIndex, int columnIndex) {
        Row row = sheet.getRow(rowIndex);
        if (row != null) {
            Cell cell = row.getCell(columnIndex);
            return cell;
        }
        return null;
    }

    public static String toMergedCellString(Cell cell) {
        Sheet sheet = cell.getSheet();
        int size = cell.getSheet().getNumMergedRegions();
        int i = 0;
        while (i < size) {
            CellRangeAddress range = sheet.getMergedRegion(i);
            if (cell.getRowIndex() == range.getFirstRow() && cell.getColumnIndex() == range.getFirstColumn()) {
                Cell upplerLeftCell = BasicExcelSheet.readCell(sheet, range.getFirstRow(), range.getFirstColumn());
                return BasicExcelSheet.toStringValue(upplerLeftCell);
            }
            ++i;
        }
        return null;
    }

    public static String toStringValue(Cell cell) {
        switch (cell.getCellType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    return DateTimeUtils.toTimestamp((Date)cell.getDateCellValue()).toString();
                }
                return Double.toString(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
            case FORMULA: {
                return BasicExcelSheet.toStringFormulaValue(cell);
            }
            case BLANK: {
                return BasicExcelSheet.toMergedCellString(cell);
            }
        }
        return null;
    }

    public static String toStringFormulaValue(Cell cell) {
        Workbook book = cell.getSheet().getWorkbook();
        CreationHelper helper = book.getCreationHelper();
        FormulaEvaluator evaluator = helper.createFormulaEvaluator();
        CellValue value = evaluator.evaluate(cell);
        switch (value.getCellType()) {
            case STRING: {
                return value.getStringValue();
            }
            case NUMERIC: {
                return Double.toString(value.getNumberValue());
            }
            case BOOLEAN: {
                return Boolean.toString(value.getBooleanValue());
            }
        }
        throw new IllegalArgumentException(ParameterizedStringFormatter.DEFAULT.format("{} is invalid", new Object[]{cell}));
    }

    public static String toStringCachedFormulaValue(Cell cell) {
        switch (cell.getCachedFormulaResultType()) {
            case STRING: {
                return cell.getStringCellValue();
            }
            case NUMERIC: {
                return Double.toString(cell.getNumericCellValue());
            }
            case BOOLEAN: {
                return Boolean.toString(cell.getBooleanCellValue());
            }
        }
        throw new IllegalArgumentException(ParameterizedStringFormatter.DEFAULT.format("{} is invalid", new Object[]{cell}));
    }

    public static class Builder {
        private final File file;
        private final String sheetName;

        public Builder(File file, String sheetName) {
            this.file = file;
            this.sheetName = sheetName;
        }

        public BasicExcelSheet build() {
            return new BasicExcelSheet(this.file, this.sheetName);
        }
    }
}

