/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.orangesignal_csv;

import com.orangesignal.csv.Csv;
import com.orangesignal.csv.CsvConfig;
import com.orangesignal.csv.CsvHandler;
import com.orangesignal.csv.handlers.ColumnNameMapListHandler;
import com.orangesignal.csv.handlers.StringArrayListHandler;
import com.orangesignal.csv.manager.CsvEntityManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.nkjmlab.util.java.function.Try;

public class OrangeSignalCsvUtils {
    public static CsvConfig createDefaultCsvConfig() {
        CsvConfig cfg = new CsvConfig(',', '\"', '\"');
        cfg.setQuoteDisabled(false);
        cfg.setEscapeDisabled(false);
        cfg.setBreakString("\n");
        cfg.setIgnoreEmptyLines(true);
        cfg.setIgnoreLeadingWhitespaces(true);
        cfg.setIgnoreTrailingWhitespaces(true);
        return cfg;
    }

    public static CsvConfig createDefaultTsvConfig() {
        CsvConfig config = OrangeSignalCsvUtils.createDefaultCsvConfig();
        config.setSeparator('\t');
        return config;
    }

    public static CsvEntityManager createDefaultCsvEntityManager() {
        return new CsvEntityManager(OrangeSignalCsvUtils.createDefaultCsvConfig());
    }

    public static List<String[]> readStringArrayList(CsvConfig csvConf, File file) {
        try {
            return OrangeSignalCsvUtils.readStringArrayList(csvConf, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public static List<String[]> readStringArrayList(CsvConfig csvConf, InputStream in) {
        return OrangeSignalCsvUtils.readStringArrayList(csvConf, new InputStreamReader(in));
    }

    public static List<String[]> readStringArrayList(CsvConfig csvConf, Reader reader) {
        try {
            return (List)Csv.load((Reader)reader, (CsvConfig)csvConf, (CsvHandler)new StringArrayListHandler());
        }
        catch (IOException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public static List<Map<String, String>> readColumnNameMapList(Reader reader) {
        return OrangeSignalCsvUtils.readColumnNameMapList(OrangeSignalCsvUtils.createDefaultCsvConfig(), reader);
    }

    public static List<Map<String, String>> readColumnNameMapList(CsvConfig csvConf, File file) {
        try {
            return OrangeSignalCsvUtils.readColumnNameMapList(csvConf, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public static List<Map<String, String>> readColumnNameMapList(CsvConfig csvConf, InputStream in) {
        return OrangeSignalCsvUtils.readColumnNameMapList(csvConf, new InputStreamReader(in));
    }

    public static List<Map<String, String>> readColumnNameMapList(CsvConfig csvConf, Reader reader) {
        try {
            return (List)Csv.load((Reader)reader, (CsvConfig)csvConf, (CsvHandler)new ColumnNameMapListHandler());
        }
        catch (IOException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public static List<Map<String, String>> readColumnNameMapList(File file) {
        try {
            return OrangeSignalCsvUtils.readColumnNameMapList(OrangeSignalCsvUtils.createDefaultCsvConfig(), new FileReader(file));
        }
        catch (FileNotFoundException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public static <T> List<T> readList(Class<T> clazz, File file) {
        return OrangeSignalCsvUtils.readList(OrangeSignalCsvUtils.createDefaultCsvConfig(), clazz, file);
    }

    public static <T> List<T> readList(Class<T> clazz, InputStream in) {
        return OrangeSignalCsvUtils.readList(OrangeSignalCsvUtils.createDefaultCsvConfig(), clazz, in);
    }

    public static <T> List<T> readList(Class<T> clazz, Reader reader) {
        return OrangeSignalCsvUtils.readList(OrangeSignalCsvUtils.createDefaultCsvConfig(), clazz, reader);
    }

    public static <T> List<T> readList(CsvConfig csvConf, Class<T> clazz, InputStream in) {
        return OrangeSignalCsvUtils.readList(csvConf, clazz, new InputStreamReader(in));
    }

    public static <T> List<T> readList(CsvConfig csvConf, Class<T> clazz, File file) {
        try {
            return OrangeSignalCsvUtils.readList(csvConf, clazz, new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> readList(CsvConfig csvConf, Class<T> clazz, Reader reader) {
        try {
            return new CsvEntityManager(csvConf).load(clazz).from(reader);
        }
        catch (IOException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public static <T> List<T> readList(CsvConfig csvConf, Class<T> clazz, String resourceName) {
        List<T> list;
        InputStreamReader reader = new InputStreamReader(OrangeSignalCsvUtils.class.getResourceAsStream(resourceName));
        try {
            list = OrangeSignalCsvUtils.readList(csvConf, clazz, reader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw Try.rethrow((Throwable)e);
            }
        }
        reader.close();
        return list;
    }

    public static List<Row> readRows(File file, String encoding, CsvConfig cfg, int offset, int limit) {
        try {
            StringArrayListHandler handler = new StringArrayListHandler();
            handler.setOffset(offset);
            handler.setLimit(limit);
            List<Row> lines = ((List)Csv.load((File)file, (String)encoding, (CsvConfig)cfg, (CsvHandler)handler)).stream().map(line -> new Row((String[])line)).collect(Collectors.toList());
            return lines;
        }
        catch (IOException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public static List<Row> readAllRows(File file, String encoding, CsvConfig cfg) {
        return OrangeSignalCsvUtils.readRows(file, encoding, cfg, 0, Integer.MAX_VALUE);
    }

    public static List<Row> readRows(InputStream in, String encoding, CsvConfig cfg, int offset, int limit) {
        try {
            StringArrayListHandler handler = new StringArrayListHandler();
            handler.setOffset(offset);
            handler.setLimit(limit);
            List<Row> lines = ((List)Csv.load((InputStream)in, (String)encoding, (CsvConfig)cfg, (CsvHandler)handler)).stream().map(line -> new Row((String[])line)).collect(Collectors.toList());
            return lines;
        }
        catch (IOException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public static List<Row> readAllRows(InputStream in, String encoding, CsvConfig cfg) {
        return OrangeSignalCsvUtils.readRows(in, encoding, cfg, 0, Integer.MAX_VALUE);
    }

    public static List<Row> readAllRows(File file, String encoding) {
        return OrangeSignalCsvUtils.readRows(file, encoding, OrangeSignalCsvUtils.createDefaultCsvConfig(), 0, Integer.MAX_VALUE);
    }

    public static List<Row> readAllRows(File file) {
        return OrangeSignalCsvUtils.readRows(file, StandardCharsets.UTF_8.toString(), OrangeSignalCsvUtils.createDefaultCsvConfig(), 0, Integer.MAX_VALUE);
    }

    public static List<Row> readAllRows(File file, CsvConfig cfg) {
        return OrangeSignalCsvUtils.readRows(file, StandardCharsets.UTF_8.toString(), cfg, 0, Integer.MAX_VALUE);
    }

    public static final class Row {
        private final List<String> cells;

        public Row(String[] line) {
            this.cells = Arrays.asList(line);
        }

        public Row(List<String> line) {
            this.cells = line;
        }

        public String get(int index) {
            try {
                return this.cells.get(index).trim();
            }
            catch (Exception e) {
                return null;
            }
        }

        public Integer getAsInteger(int index) {
            try {
                return Integer.valueOf(this.get(index));
            }
            catch (Exception e) {
                return null;
            }
        }

        public Double getAsDouble(int index) {
            try {
                return Double.valueOf(this.get(index));
            }
            catch (Exception e) {
                return null;
            }
        }

        public boolean isHeadCellEquals(String str) {
            return this.get(0).equals(str);
        }

        public Boolean getAsBoolean(int index) {
            try {
                return Boolean.valueOf(this.get(index));
            }
            catch (Exception e) {
                return null;
            }
        }

        public Float getAsFloat(int index) {
            try {
                return Float.valueOf(this.get(index));
            }
            catch (Exception e) {
                return null;
            }
        }

        public String toString() {
            return "Row [cells=" + this.cells + "]";
        }
    }
}

