/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.thymeleaf;

import java.util.ArrayList;
import java.util.List;
import org.nkjmlab.util.thymeleaf.ThymeleafTemplateResolverBuilder;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class ThymeleafTemplateEnginBuilder {
    private ThymeleafTemplateResolverBuilder templateResolverBuilder = ThymeleafTemplateResolverBuilder.builder();
    private final List<IDialect> dialects = new ArrayList<IDialect>();

    public static ThymeleafTemplateEnginBuilder builder() {
        return new ThymeleafTemplateEnginBuilder();
    }

    public ThymeleafTemplateEnginBuilder setPrefix(String prefix) {
        this.templateResolverBuilder.setPrefix(prefix);
        return this;
    }

    public ThymeleafTemplateEnginBuilder setSuffix(String suffix) {
        this.templateResolverBuilder.setSuffix(suffix);
        return this;
    }

    public ThymeleafTemplateEnginBuilder setTtlMs(long cacheTtlMs) {
        this.templateResolverBuilder.setCacheTtlMs(cacheTtlMs);
        return this;
    }

    public ThymeleafTemplateEnginBuilder setTemplateResolver(AbstractConfigurableTemplateResolver templateResolver) {
        this.templateResolverBuilder.setTemplateResolver(templateResolver);
        return this;
    }

    public ThymeleafTemplateEnginBuilder addDialect(IDialect dialect) {
        this.dialects.add(dialect);
        return this;
    }

    public TemplateEngine build() {
        TemplateEngine engine = new TemplateEngine();
        engine.setTemplateResolver((ITemplateResolver)this.templateResolverBuilder.build());
        this.dialects.forEach(d -> engine.addDialect(d));
        return engine;
    }
}

