/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.thymeleaf;

import java.nio.charset.StandardCharsets;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;

public class ThymeleafTemplateResolverBuilder {
    private String prefix = "/templates/";
    private String suffix = ".html";
    private long cacheTtlMs = -1L;
    private TemplateMode templateMode = TemplateMode.HTML;
    private AbstractConfigurableTemplateResolver templateResolver = new ClassLoaderTemplateResolver();

    public static ThymeleafTemplateResolverBuilder builder() {
        return new ThymeleafTemplateResolverBuilder();
    }

    public AbstractConfigurableTemplateResolver build() {
        this.templateResolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
        this.templateResolver.setTemplateMode(this.templateMode);
        this.templateResolver.setPrefix(this.prefix);
        this.templateResolver.setSuffix(this.suffix);
        if (this.cacheTtlMs > 0L) {
            this.templateResolver.setCacheable(true);
            this.templateResolver.setCacheTTLMs(Long.valueOf(this.cacheTtlMs));
        } else {
            this.templateResolver.setCacheable(false);
        }
        return this.templateResolver;
    }

    public ThymeleafTemplateResolverBuilder setPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public ThymeleafTemplateResolverBuilder setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public ThymeleafTemplateResolverBuilder setCacheTtlMs(long cacheTtlMs) {
        this.cacheTtlMs = cacheTtlMs;
        return this;
    }

    public ThymeleafTemplateResolverBuilder setTemplateMode(TemplateMode templateMode) {
        this.templateMode = templateMode;
        return this;
    }

    public ThymeleafTemplateResolverBuilder setTemplateResolver(AbstractConfigurableTemplateResolver templateResolver) {
        this.templateResolver = templateResolver;
        return this;
    }
}

