/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.javalin;

import io.javalin.http.Context;
import org.nkjmlab.util.jakarta.servlet.JsonRpcService;
import org.nkjmlab.util.java.json.JsonMapper;
import org.nkjmlab.util.java.lang.ParameterizedStringFormatter;
import org.nkjmlab.util.java.logging.LogManager;
import org.nkjmlab.util.java.logging.SimpleLogger;
import org.nkjmlab.util.jsonrpc.JsonRpcRequest;
import org.nkjmlab.util.jsonrpc.JsonRpcResponse;

public class JavalinJsonRpcService
extends JsonRpcService {
    private static final SimpleLogger log = LogManager.createLogger();

    public JavalinJsonRpcService(JsonMapper mapper) {
        super(mapper);
    }

    public void handle(Context ctx, Object service) {
        JsonRpcRequest jreq = this.toJsonRpcRequest(ctx.req());
        JsonRpcResponse jres = this.callHttpJsonRpc(service, jreq, ctx.res());
        if (jres.hasError()) {
            log.warn(ParameterizedStringFormatter.LENGTH_512.format("[{}#{}], Req: id={}, Error: code={}, msg={}, detail = {}", new Object[]{service.getClass().getName(), jreq.getMethod(), jreq.getId(), jres.getError().getCode(), jres.getError().getMessage(), jres.getError().getData()}), new Object[0]);
        }
        String ret = this.toJsonString(jres);
        ctx.result(ret);
    }
}

