/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.openai.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Properties;
import org.nkjmlab.util.openai.OpenAi4jException;
import org.nkjmlab.util.openai.chat.model.ChatRequest;
import org.nkjmlab.util.openai.chat.model.ChatResponse;

public class ChatCompletion {
    private final String authHeader;
    private final URI apiUrl;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    public static void main(String[] args) {
        ChatResponse res = ChatCompletion.builder().build().createCompletion("What do you think would be good for dinner tonight?");
        System.out.println(res);
    }

    private ChatCompletion(Builder builder) {
        this.authHeader = "Bearer " + builder.apiKey;
        this.apiUrl = builder.apiUrl;
        this.httpClient = HttpClient.newBuilder().connectTimeout(Duration.of(builder.timeout, ChronoUnit.MILLIS)).build();
        this.objectMapper = builder.objectMapper;
    }

    public ChatResponse createCompletion(String text) throws OpenAi4jException {
        return this.createCompletion(ChatRequest.builder().messages(ChatRequest.ChatMessage.of(ChatRequest.ChatMessage.Role.USER, text)).build());
    }

    public ChatResponse createCompletion(ChatRequest chatRequest) throws OpenAi4jException {
        try {
            HttpRequest req = this.createHttpRequest(chatRequest);
            HttpResponse<byte[]> res = this.httpClient.send(req, HttpResponse.BodyHandlers.ofByteArray());
            ChatResponse chatResponse = (ChatResponse)this.objectMapper.readValue(res.body(), ChatResponse.class);
            return chatResponse;
        }
        catch (Exception e) {
            throw new OpenAi4jException("error occurs when it calls completion api", e);
        }
    }

    private HttpRequest createHttpRequest(ChatRequest chatRequest) throws JsonProcessingException {
        return HttpRequest.newBuilder().uri(this.apiUrl).header("Authorization", this.authHeader).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofByteArray(this.objectMapper.writeValueAsBytes((Object)chatRequest))).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String apiKey;
        private long timeout = 120000L;
        private URI apiUrl = Builder.toURI("https://api.openai.com/v1/chat/completions");
        private ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setSerializationInclusion(JsonInclude.Include.NON_NULL);

        public Builder apiKeyFromSystemEnv() {
            String key = System.getenv("OPENAI4J_SECRET_TOKEN");
            if (key != null && key.toString().length() > 0) {
                this.apiKey(key.toString());
                return this;
            }
            throw new RuntimeException("System env OPENAI4J_SECRET_TOKEN is not found or not valid.");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Builder apiKeyFromProperties(String resourceName) {
            try (InputStream is = ChatCompletion.class.getResourceAsStream(resourceName);){
                Properties props = new Properties();
                props.load(is);
                Object key = props.get("secretKey");
                if (key == null) throw new RuntimeException("/openai4j.properties is invalid.");
                if (key.toString().length() <= 0) throw new RuntimeException("/openai4j.properties is invalid.");
                this.apiKey(key.toString());
                Builder builder = this;
                return builder;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder timeout(long timeout) {
            this.timeout = timeout;
            return this;
        }

        public Builder apiUrl(String apiUrl) {
            this.apiUrl = Builder.toURI(apiUrl);
            return this;
        }

        public Builder mapper(ObjectMapper mapper) {
            this.objectMapper = mapper;
            return this;
        }

        public ChatCompletion build() {
            return new ChatCompletion(this);
        }

        private static URI toURI(String uri) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new OpenAi4jException(uri + " is invalid", e);
            }
        }
    }
}

