/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.commons.csv;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.nkjmlab.sorm4j.internal.util.Try;

public class CommonsCsvUtils {
    public static void write(CSVFormat format, Appendable writer, List<String[]> csvLines) {
        try (CSVPrinter printer = format.print(writer);){
            for (String[] line : csvLines) {
                printer.printRecord((Object[])line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void write(CSVFormat format, File outFile, Charset charset, boolean append, List<String[]> csvLines) {
        try (FileWriter writer = new FileWriter(outFile, charset, append);){
            CommonsCsvUtils.write(format, writer, csvLines);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void readAndConsumeCsvRecord(CSVFormat format, File srcFile, Charset charset, Consumer<CSVRecord> consumer) {
        try (FileReader in = new FileReader(srcFile, charset);){
            CSVParser records = format.parse((Reader)in);
            for (CSVRecord record : records) {
                consumer.accept(record);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<CSVRecord> readCsvRecordList(CSVFormat format, File srcFile, Charset charset) {
        List<CSVRecord> list;
        FileReader in = new FileReader(srcFile, charset);
        try {
            list = CommonsCsvUtils.readCsvRecordList(format, in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw Try.rethrow((Throwable)e);
            }
        }
        ((Reader)in).close();
        return list;
    }

    public static List<CSVRecord> readCsvRecordList(CSVFormat format, Reader reader) {
        try {
            CSVParser records = format.parse(reader);
            return StreamSupport.stream(records.spliterator(), false).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw Try.rethrow((Throwable)e);
        }
    }
}

