/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.firebase.auth;

import com.google.firebase.auth.FirebaseToken;
import java.util.Optional;
import org.nkjmlab.util.firebase.auth.FirebaseAuthService;
import org.nkjmlab.util.firebase.auth.FirebaseSigninSession;
import org.nkjmlab.util.firebase.auth.FirebaseSigninSessionsTable;

public abstract class AbstractFirebaseAuthService
implements FirebaseAuthService {
    private final FirebaseSigninSessionsTable signinSessionsTable = new FirebaseSigninSessionsTable();

    public AbstractFirebaseAuthService() {
        this.signinSessionsTable.createTableIfNotExists().createIndexesIfNotExists();
    }

    @Override
    public Optional<FirebaseSigninSession> signin(String sessionId, String idToken) {
        return this.isAcceptableIdToken(idToken).map(token -> Optional.of(this.signinSessionsTable.signin(sessionId, (FirebaseToken)token))).orElse(Optional.empty());
    }

    @Override
    public Optional<FirebaseSigninSession> selectBySessionId(String sessionId) {
        FirebaseSigninSession s = (FirebaseSigninSession)this.signinSessionsTable.selectByPrimaryKey(new Object[]{sessionId});
        return s != null ? Optional.of(s) : Optional.empty();
    }

    @Override
    public boolean isSignin(String sessionId) {
        return this.signinSessionsTable.exists(new Object[]{sessionId});
    }

    @Override
    public boolean signout(String sessionId) {
        this.signinSessionsTable.deleteByPrimaryKey(new Object[]{sessionId});
        return true;
    }
}

