/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.javax.mail;

import java.util.Arrays;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;

public class MailSender {
    private final String loginId;
    private final String password;
    private final String host;
    private final int port;

    public MailSender(String host, int port, String loginId, String password) {
        this.host = host;
        this.port = port;
        this.loginId = loginId;
        this.password = password;
    }

    public MimeMessage createMimeMessage(String from, String to, String cc, String bcc, String subject, String text) {
        try {
            Session session = this.createSession();
            MimeMessage mimeMessage = new MimeMessage(session);
            mimeMessage.setFrom((Address)new InternetAddress(from));
            mimeMessage.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(to));
            if (cc != null && cc.length() != 0) {
                mimeMessage.addRecipient(Message.RecipientType.CC, (Address)new InternetAddress(cc));
            }
            if (bcc != null && bcc.length() != 0) {
                mimeMessage.addRecipient(Message.RecipientType.BCC, (Address)new InternetAddress(bcc));
            }
            mimeMessage.setSubject(subject);
            mimeMessage.setText(text);
            mimeMessage.saveChanges();
            return mimeMessage;
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendMessage(MimeMessage message) {
        try {
            Transport.send((Message)message);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getMailHeader(MimeMessage message) {
        try {
            String from = "from: " + String.join((CharSequence)",", Arrays.stream(message.getFrom()).map(a -> a.toString()).collect(Collectors.toList()));
            String to = "to: " + String.join((CharSequence)",", Arrays.stream(message.getRecipients(Message.RecipientType.TO)).map(a -> a.toString()).collect(Collectors.toList()));
            String cc = "cc: " + String.join((CharSequence)",", Arrays.stream(message.getRecipients(Message.RecipientType.CC)).map(a -> a.toString()).collect(Collectors.toList()));
            String bcc = "bcc: " + String.join((CharSequence)",", Arrays.stream(message.getRecipients(Message.RecipientType.BCC)).map(a -> a.toString()).collect(Collectors.toList()));
            String subject = message.getSubject();
            return String.join((CharSequence)System.lineSeparator(), from, to, cc, bcc, subject);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    private Session createSession() {
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.host", this.host);
        properties.setProperty("mail.smtp.port", String.valueOf(this.port));
        if (this.port != 25) {
            properties.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.setProperty("mail.smtp.socketFactory.fallback", "false");
            properties.setProperty("mail.smtp.socketFactory.port", String.valueOf(this.port));
        }
        properties.setProperty("mail.smtp.connectiontimeout", "50000");
        properties.setProperty("mail.smtp.timeout", "50000");
        properties.setProperty("mail.smtp.auth", "true");
        return Session.getInstance((Properties)properties, (Authenticator)this.createAuthenticator());
    }

    private Authenticator createAuthenticator() {
        Authenticator auth = new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(MailSender.this.loginId, MailSender.this.password);
            }
        };
        return auth;
    }
}

