/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.thymeleaf;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.templatemode.TemplateMode;
import org.thymeleaf.templateresolver.AbstractConfigurableTemplateResolver;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;

public class TemplateEngineBuilder {
    private final TemplateResolverBuilder templateResolverBuilder = TemplateResolverBuilder.builder();
    private final List<IDialect> dialects = new ArrayList<IDialect>();

    public static TemplateEngineBuilder builder() {
        return new TemplateEngineBuilder();
    }

    public TemplateEngineBuilder setPrefix(String prefix) {
        this.templateResolverBuilder.setPrefix(prefix);
        return this;
    }

    public TemplateEngineBuilder setSuffix(String suffix) {
        this.templateResolverBuilder.setSuffix(suffix);
        return this;
    }

    public TemplateEngineBuilder setCacheTtlMs(long cacheTtlMs) {
        this.templateResolverBuilder.setCacheTtlMs(cacheTtlMs);
        return this;
    }

    public TemplateEngineBuilder setTemplateResolver(AbstractConfigurableTemplateResolver templateResolver) {
        this.templateResolverBuilder.setTemplateResolver(templateResolver);
        return this;
    }

    public TemplateEngineBuilder addDialect(IDialect dialect) {
        this.dialects.add(dialect);
        return this;
    }

    public TemplateEngine build() {
        TemplateEngine engine = new TemplateEngine();
        engine.setTemplateResolver((ITemplateResolver)this.templateResolverBuilder.build());
        this.dialects.forEach(d -> engine.addDialect(d));
        return engine;
    }

    public static class TemplateResolverBuilder {
        private String prefix = "/templates/";
        private String suffix = ".html";
        private Long cacheTtlMs = -1L;
        private TemplateMode templateMode = TemplateMode.HTML;
        private AbstractConfigurableTemplateResolver templateResolver = new ClassLoaderTemplateResolver();

        public static TemplateResolverBuilder builder() {
            return new TemplateResolverBuilder();
        }

        public AbstractConfigurableTemplateResolver build() {
            this.templateResolver.setCharacterEncoding(StandardCharsets.UTF_8.name());
            this.templateResolver.setTemplateMode(this.templateMode);
            this.templateResolver.setPrefix(this.prefix);
            this.templateResolver.setSuffix(this.suffix);
            if (this.cacheTtlMs > 0L) {
                this.templateResolver.setCacheable(true);
                this.templateResolver.setCacheTTLMs(this.cacheTtlMs);
            } else {
                this.templateResolver.setCacheable(false);
            }
            return this.templateResolver;
        }

        public TemplateResolverBuilder setPrefix(String prefix) {
            this.prefix = prefix;
            return this;
        }

        public TemplateResolverBuilder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public TemplateResolverBuilder setCacheTtlMs(Long cacheTtlMs) {
            this.cacheTtlMs = cacheTtlMs;
            return this;
        }

        public TemplateResolverBuilder setTemplateMode(TemplateMode templateMode) {
            this.templateMode = templateMode;
            return this;
        }

        public TemplateResolverBuilder setTemplateResolver(AbstractConfigurableTemplateResolver templateResolver) {
            this.templateResolver = templateResolver;
            return this;
        }
    }
}

