/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.firebase.auth;

import com.google.auth.oauth2.ServiceAccountCredentials;
import com.google.firebase.auth.FirebaseToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Optional;
import org.nkjmlab.sorm4j.util.function.exception.Try;
import org.nkjmlab.util.firebase.auth.AbstractFirebaseAuthService;
import org.nkjmlab.util.firebase.auth.BasicFirebaseAuthHandler;

public class BasicFirebaseAuthService
extends AbstractFirebaseAuthService {
    private final BasicFirebaseAuthHandler authHandler;

    private BasicFirebaseAuthService(Collection<String> acceptableEmails, ServiceAccountCredentials credentials) {
        this.authHandler = new BasicFirebaseAuthHandler(acceptableEmails, credentials);
    }

    public static BasicFirebaseAuthService create(Collection<String> acceptableEmails, File firebaseServiceAccountJson) {
        BasicFirebaseAuthService basicFirebaseAuthService;
        FileInputStream serviceAccount = new FileInputStream(firebaseServiceAccountJson);
        try {
            ServiceAccountCredentials credentials = ServiceAccountCredentials.fromStream((InputStream)serviceAccount);
            basicFirebaseAuthService = new BasicFirebaseAuthService(acceptableEmails, credentials);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)serviceAccount).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw Try.rethrow((Throwable)e);
            }
        }
        ((InputStream)serviceAccount).close();
        return basicFirebaseAuthService;
    }

    @Override
    public Optional<FirebaseToken> isAcceptableIdToken(String idToken) {
        return this.authHandler.isAcceptableIdToken(idToken);
    }
}

