/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.util.jakarta.websocket;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import jakarta.websocket.CloseReason;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Session;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nkjmlab.sorm4j.util.function.exception.Try;
import org.nkjmlab.util.jakarta.websocket.WebsocketClientEndpoint;

public class WebsocketClientSession {
    private static final Logger log = LogManager.getLogger();
    private final Session session;

    public static Builder builder(String uri) {
        return new Builder(uri);
    }

    public void close() {
        try {
            this.session.close();
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    public void sendMessage(String message) {
        try {
            this.session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            throw Try.rethrow((Throwable)e);
        }
    }

    public String toString() {
        return "WebsocketClient [session=" + String.valueOf(this.session) + "]";
    }

    public Session getSession() {
        return this.session;
    }

    private WebsocketClientSession(Session session) {
        this.session = session;
    }

    public static class Builder {
        private MessagePassingQueue.Consumer<Session> onOpenHandler = session -> log.debug("onOpen={}", session);
        private BiConsumer<String, Session> onMessageHandler = (message, session) -> log.debug("[{}] onMessage {}", (Object)session.getId(), message);
        private BiConsumer<CloseReason, Session> onCloseHandler = (closeReason, session) -> {
            log.debug("[{}] onClose {}", (Object)session.getId(), closeReason);
            try {
                session.close();
            }
            catch (IOException e) {
                log.error((Object)e, (Throwable)e);
            }
        };
        private BiConsumer<Throwable, Session> onErrorHandler = (th, session) -> log.debug("[{}] onError {}", (Object)session.getId(), th);
        private URI uri;

        private Builder(String uri) {
            this.uri = this.toUri(uri);
        }

        private URI toUri(String uri) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                throw Try.rethrow((Throwable)e);
            }
        }

        public void setOnOpenHandler(MessagePassingQueue.Consumer<Session> onOpenHandler) {
            this.onOpenHandler = onOpenHandler;
        }

        public void setOnMessageHandler(BiConsumer<String, Session> onMessageHandler) {
            this.onMessageHandler = onMessageHandler;
        }

        public void setOnCloseHandler(BiConsumer<CloseReason, Session> onCloseHandler) {
            this.onCloseHandler = onCloseHandler;
        }

        public void setOnErrorHandler(BiConsumer<Throwable, Session> onErrorHandler) {
            this.onErrorHandler = onErrorHandler;
        }

        public WebsocketClientSession open() {
            try {
                WebsocketClientEndpoint endpoint = new WebsocketClientEndpoint(this.onOpenHandler, this.onMessageHandler, this.onCloseHandler, this.onErrorHandler);
                Session session = ContainerProvider.getWebSocketContainer().connectToServer((Object)endpoint, this.uri);
                if (session.isOpen()) {
                    log.debug("[{}] session is open to {}", (Object)session.getId(), (Object)this.uri);
                }
                return new WebsocketClientSession(session);
            }
            catch (DeploymentException | IOException e) {
                log.error("error occurs" + String.valueOf(this.uri), e);
                throw Try.rethrow((Throwable)e);
            }
        }
    }
}

