package org.nkjmlab.sorm4j.result;

import java.util.List;

/**
 * Represents a result from an insert operation with auto-generated keys.
 */
public final class InsertResult<T> {

  private final int[] rowsModified;
  /**
   * last inserted object with auto-generated keys
   */
  private final T object;

  private final List<Object> autoGeneratedKeys;

  public InsertResult(int[] rowsModified, T lastInsertedObject, List<Object> autoGeneratedKeys) {
    this.rowsModified = rowsModified;
    this.object = lastInsertedObject;
    this.autoGeneratedKeys = autoGeneratedKeys;
  }

  /**
   * Returns the row count for DML statements {@link java.sql.PreparedStatement#executeUpdate()}.
   */
  public int[] getRowsModified() {
    return rowsModified;
  }

  /**
   * Returns the object which insert last with auto-generated keys.
   *
   * @return
   */
  public T getObject() {
    return object;
  }

  public List<Object> getAutoGeneratedKeys() {
    return autoGeneratedKeys;
  }

  public static <T> InsertResult<T> empty() {
    return new InsertResult<T>(new int[] {0}, null, null);
  }


}
