/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.SqlExecutor;
import org.nkjmlab.sorm4j.mapping.ColumnsMapping;
import org.nkjmlab.sorm4j.mapping.LazyResultSetImpl;
import org.nkjmlab.sorm4j.mapping.MultiRowProcessorGeneratorFactory;
import org.nkjmlab.sorm4j.mapping.OrmConfigStore;
import org.nkjmlab.sorm4j.mapping.PreparedStatementUtils;
import org.nkjmlab.sorm4j.mapping.TableMapping;
import org.nkjmlab.sorm4j.mapping.TableName;
import org.nkjmlab.sorm4j.mapping.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.mapping.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.mapping.extension.SqlParameterSetter;
import org.nkjmlab.sorm4j.mapping.extension.TableNameMapper;
import org.nkjmlab.sorm4j.result.LazyResultSet;
import org.nkjmlab.sorm4j.util.DebugPoint;
import org.nkjmlab.sorm4j.util.DebugPointFactory;
import org.nkjmlab.sorm4j.util.LoggerFactory;
import org.nkjmlab.sorm4j.util.StringUtils;
import org.nkjmlab.sorm4j.util.Try;
import org.slf4j.Logger;

abstract class AbstractOrmMapper
implements SqlExecutor {
    private static final Logger log = LoggerFactory.getLogger();
    private final ColumnFieldMapper fieldMapper;
    private final TableNameMapper tableNameMapper;
    private final ResultSetConverter resultSetConverter;
    private final SqlParameterSetter sqlParameterSetter;
    private final Connection connection;
    private final MultiRowProcessorGeneratorFactory batchConfig;
    private final OrmConfigStore configStore;
    private final ConcurrentMap<String, TableMapping<?>> tableMappings;
    private final ConcurrentMap<Class<?>, ColumnsMapping<?>> columnsMappings;
    private final ConcurrentMap<Class<?>, TableName> classNameToValidTableNameMap;
    private final ConcurrentMap<String, TableName> tableNameToValidTableNameMap;
    private static final Set<Class<?>> nativeSqlTypes = Set.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, byte[].class, Byte[].class, char[].class, Character[].class, String.class, BigDecimal.class, java.util.Date.class, Date.class, Time.class, Timestamp.class, InputStream.class, Reader.class, Clob.class, Blob.class, Object.class);

    public AbstractOrmMapper(Connection connection, OrmConfigStore configStore) {
        this.connection = connection;
        this.configStore = configStore;
        this.batchConfig = configStore.getMultiProcessorFactory();
        this.fieldMapper = configStore.getColumnFieldMapper();
        this.tableNameMapper = configStore.getTableNameMapper();
        this.resultSetConverter = configStore.getSqlToJavaDataConverter();
        this.sqlParameterSetter = configStore.getSqlParameterSetter();
        this.tableMappings = configStore.getTableMappings();
        this.columnsMappings = configStore.getColumnsMappings();
        this.classNameToValidTableNameMap = configStore.getClassNameToValidTableNameMap();
        this.tableNameToValidTableNameMap = configStore.getTableNameToValidTableNameMaps();
    }

    public <T> int deleteAll(Class<T> objectClass) {
        return this.getTableMapping(objectClass).deleteAll(this.connection);
    }

    public int deleteAllOn(String tableName) {
        return this.executeUpdate("DELETE FROM " + tableName, new Object[0]);
    }

    protected final <T, R> R execSqlIfParameterExists(T[] objects, Function<TableMapping<T>, R> sqlFunction, Supplier<R> notExists) {
        if (objects == null || objects.length == 0) {
            return notExists.get();
        }
        TableMapping<T> mapping = this.getCastedTableMapping(objects[0].getClass());
        return sqlFunction.apply(mapping);
    }

    protected final <T, R> R execSqlIfParameterExists(String tableName, T[] objects, Function<TableMapping<T>, R> sqlFunction, Supplier<R> notExists) {
        if (objects == null || objects.length == 0) {
            return notExists.get();
        }
        TableMapping<T> mapping = this.getCastedTableMapping(tableName, objects[0].getClass());
        return sqlFunction.apply(mapping);
    }

    @Override
    public boolean execute(String sql, Object ... parameters) {
        return AbstractOrmMapper.execPreparedStatementAndClose(this.sqlParameterSetter, this.connection, sql, parameters, stmt -> stmt.execute());
    }

    @Override
    public ResultSet executeQuery(String sql, Object ... parameters) {
        return AbstractOrmMapper.execPreparedStatementAndClose(this.sqlParameterSetter, this.connection, sql, parameters, stmt -> stmt.executeQuery());
    }

    @Override
    public int executeUpdate(String sql, Object ... parameters) {
        return AbstractOrmMapper.execPreparedStatementAndClose(this.sqlParameterSetter, this.connection, sql, parameters, stmt -> stmt.executeUpdate());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <R> R execStatementAndReadResultSet(String sql, Object[] parameters, Try.ThrowableFunction<ResultSet, R> sqlResultReader) {
        try (PreparedStatement stmt = PreparedStatementUtils.getPreparedStatement(this.connection, sql);){
            Object r;
            block14: {
                this.sqlParameterSetter.setParameters(stmt, parameters);
                ResultSet resultSet = stmt.executeQuery();
                try {
                    Optional<DebugPoint> dp = DebugPointFactory.createDebugPoint(DebugPointFactory.Name.READ);
                    dp.ifPresent(sw -> log.debug("[{}] with {} ", (Object)sql, (Object)parameters));
                    Object ret = sqlResultReader.apply(resultSet);
                    dp.ifPresent(sw -> log.debug("{} Read [{}] objects from [{}]", new Object[]{sw.getFormattedNameAndElapsedTime(), ret instanceof Collection ? ((Collection)ret).size() : 1, Try.getOrNull(() -> this.connection.getMetaData().getURL())}));
                    r = ret;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return r;
        }
        catch (Throwable e) {
            String msg = parameters == null || parameters.length == 0 ? StringUtils.format("Error in [{}]", sql) : StringUtils.format("Error in [{}] with {}", sql, parameters);
            throw new OrmException(msg, e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final <R> R execPreparedStatementAndClose(SqlParameterSetter sqlParameterSetter, Connection connection, String sql, Object[] parameters, Try.ThrowableFunction<PreparedStatement, R> func) {
        try (PreparedStatement stmt = PreparedStatementUtils.getPreparedStatement(connection, sql);){
            sqlParameterSetter.setParameters(stmt, parameters);
            R r = func.apply(stmt);
            return r;
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    protected <T> TableMapping<T> getCastedTableMapping(Class<?> objectClass) {
        return this.getTableMapping(objectClass);
    }

    protected <T> TableMapping<T> getCastedTableMapping(String tableName, Class<?> objectClass) {
        return this.getTableMapping(tableName, objectClass);
    }

    <T> ColumnsMapping<T> getColumnsMapping(Class<T> objectClass) {
        ColumnsMapping ret = this.columnsMappings.computeIfAbsent(objectClass, _k -> {
            ColumnsMapping m = ColumnsMapping.createMapping(objectClass, this.resultSetConverter, this.fieldMapper);
            log.info(System.lineSeparator() + m.getFormattedString());
            return m;
        });
        return ret;
    }

    public OrmConfigStore getConfigStore() {
        return this.configStore;
    }

    @Override
    public Connection getJdbcConnection() {
        return this.connection;
    }

    public <T> TableMapping<T> getTableMapping(Class<T> objectClass) {
        TableName tableName = this.toTableName(objectClass);
        return this.getTableMapping(tableName, objectClass);
    }

    <T> TableMapping<T> getTableMapping(String tableName, Class<T> objectClass) {
        return this.getTableMapping(this.toTableName(tableName), objectClass);
    }

    <T> TableMapping<T> getTableMapping(TableName tableName, Class<T> objectClass) {
        String key = tableName.getName() + "-" + objectClass.getName();
        TableMapping ret = this.tableMappings.computeIfAbsent(key, Try.createFunctionWithThrow(_key -> {
            TableMapping m = TableMapping.createMapping(this.resultSetConverter, this.sqlParameterSetter, objectClass, tableName.getName(), this.fieldMapper, this.batchConfig, this.connection);
            log.info(System.lineSeparator() + m.getFormattedString());
            return m;
        }, OrmException::new));
        return ret;
    }

    <T> T loadFirst(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        if (resultSet.next()) {
            return this.toSingleObject(objectClass, resultSet);
        }
        return null;
    }

    Map<String, Object> loadFirstMap(ResultSet resultSet) throws SQLException {
        Map<String, Object> ret = null;
        if (resultSet.next()) {
            ret = this.toSingleMap(resultSet);
        }
        return ret;
    }

    List<Map<String, Object>> loadMapList(ResultSet resultSet) throws SQLException {
        ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
        ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
        while (resultSet.next()) {
            ret.add(this.resultSetConverter.toSingleMap(resultSet, ct.getColumns(), ct.getColumnTypes()));
        }
        return ret;
    }

    private final <T> List<T> loadNativeObjectList(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        Try.runOrThrow(() -> {
            ResultSetMetaData metaData = resultSet.getMetaData();
            if (metaData.getColumnCount() != 1) {
                throw new OrmException("ResultSet returned [" + metaData.getColumnCount() + "] columns but 1 column was expected to load data into an instance of [" + objectClass.getName() + "]");
            }
        }, OrmException::wrapIfNotOrmException);
        ArrayList<T> ret = new ArrayList<T>();
        while (resultSet.next()) {
            ret.add(this.resultSetConverter.toSingleNativeObject(resultSet, objectClass));
        }
        return ret;
    }

    <T> T loadOne(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        T ret = null;
        if (resultSet.next()) {
            ret = this.toSingleObject(objectClass, resultSet);
        }
        if (resultSet.next()) {
            throw new RuntimeException("Non-unique result returned");
        }
        return ret;
    }

    Map<String, Object> loadOneMap(ResultSet resultSet) throws SQLException {
        Map<String, Object> ret = null;
        if (resultSet.next()) {
            ret = this.toSingleMap(resultSet);
        }
        if (resultSet.next()) {
            throw new OrmException("Non-unique result returned");
        }
        return ret;
    }

    final <T> List<T> readAllAux(Class<T> objectClass) {
        TableMapping<T> mapping = this.getTableMapping(objectClass);
        String sql = mapping.getSql().getSelectAllSql();
        Optional<DebugPoint> dp = DebugPointFactory.createDebugPoint(DebugPointFactory.Name.READ);
        List result = this.readListAux(objectClass, sql, new Object[0]);
        dp.ifPresent(sw -> log.debug("{} Read [{}] objects of [{}]", new Object[]{sw.getFormattedNameAndElapsedTime(), result.size(), objectClass.getSimpleName()}));
        return result;
    }

    final <T> LazyResultSet<T> readAllLazyAux(Class<T> objectClass) {
        return this.readLazyAux(objectClass, this.getTableMapping(objectClass).getSql().getSelectAllSql(), new Object[0]);
    }

    final <T> T readByPrimaryKeyAux(Class<T> objectClass, Object ... primaryKeyValues) {
        TableMapping<T> mapping = this.getTableMapping(objectClass);
        mapping.throwExeptionIfPrimaryKeysIsNotExist();
        String sql = mapping.getSql().getSelectByPrimaryKeySql();
        return this.readFirstAux(objectClass, sql, primaryKeyValues);
    }

    final <T> T readFirstAux(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)this.execStatementAndReadResultSet(sql, parameters, resultSet -> this.loadFirst(objectClass, (ResultSet)resultSet));
    }

    final <T> LazyResultSet<T> readLazyAux(Class<T> objectClass, String sql, Object ... parameters) {
        try {
            PreparedStatement stmt = PreparedStatementUtils.getPreparedStatement(this.connection, sql);
            this.sqlParameterSetter.setParameters(stmt, parameters);
            ResultSet resultSet = stmt.executeQuery();
            return new LazyResultSetImpl<T>(this, objectClass, stmt, resultSet);
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    final <T> List<T> readListAux(Class<T> objectClass, String sql, Object ... parameters) {
        return this.execStatementAndReadResultSet(sql, parameters, resultSet -> AbstractOrmMapper.isEnableToConvertNativeSqlType(objectClass) ? this.loadNativeObjectList(objectClass, (ResultSet)resultSet) : this.toPojoList(objectClass, (ResultSet)resultSet));
    }

    public Map<String, Object> readMapFirst(String sql, Object ... parameters) {
        return this.execStatementAndReadResultSet(sql, parameters, resultSet -> {
            ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
            if (resultSet.next()) {
                return this.resultSetConverter.toSingleMap((ResultSet)resultSet, ct.getColumns(), ct.getColumnTypes());
            }
            return null;
        });
    }

    public LazyResultSet<Map<String, Object>> readMapLazy(String sql, Object ... parameters) {
        try {
            PreparedStatement stmt = PreparedStatementUtils.getPreparedStatement(this.connection, sql);
            this.sqlParameterSetter.setParameters(stmt, parameters);
            ResultSet resultSet = stmt.executeQuery();
            LazyResultSetImpl<Map<String, Object>> ret = new LazyResultSetImpl<Map<String, Object>>(this, LinkedHashMap.class, stmt, resultSet);
            return ret;
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    public List<Map<String, Object>> readMapList(String sql, Object ... parameters) {
        return this.execStatementAndReadResultSet(sql, parameters, resultSet -> this.loadMapList((ResultSet)resultSet));
    }

    public Map<String, Object> readMapOne(String sql, Object ... parameters) {
        return this.execStatementAndReadResultSet(sql, parameters, resultSet -> {
            ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
            Map<String, Object> ret = null;
            if (resultSet.next()) {
                ret = this.resultSetConverter.toSingleMap((ResultSet)resultSet, ct.getColumns(), ct.getColumnTypes());
            }
            if (resultSet.next()) {
                throw new OrmException("Non-unique result returned");
            }
            return ret;
        });
    }

    final <T> T readOneAux(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)this.execStatementAndReadResultSet(sql, parameters, resultSet -> {
            Object ret = null;
            if (resultSet.next()) {
                ret = this.toSingleObject(objectClass, (ResultSet)resultSet);
            }
            if (resultSet.next()) {
                throw new OrmException("Non-unique result returned");
            }
            return ret;
        });
    }

    public final <T> List<T> toPojoList(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        ColumnsMapping<T> mapping = this.getColumnsMapping(objectClass);
        return mapping.loadPojoList(resultSet);
    }

    public Map<String, Object> toSingleMap(ResultSet resultSet) throws SQLException {
        ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
        return this.resultSetConverter.toSingleMap(resultSet, ct.getColumns(), ct.getColumnTypes());
    }

    public <T> T toSingleObject(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        return AbstractOrmMapper.isEnableToConvertNativeSqlType(objectClass) ? this.resultSetConverter.toSingleNativeObject(resultSet, objectClass) : this.toSinglePojo(objectClass, resultSet);
    }

    private final <T> T toSinglePojo(Class<T> objectClass, ResultSet resultSet) throws SQLException {
        ColumnsMapping<T> mapping = this.getColumnsMapping(objectClass);
        return mapping.loadPojo(resultSet);
    }

    private TableName toTableName(Class<?> objectClass) {
        return this.classNameToValidTableNameMap.computeIfAbsent(objectClass, Try.createFunctionWithThrow(k -> this.tableNameMapper.getTableName(objectClass, this.connection.getMetaData()), OrmException::new));
    }

    private TableName toTableName(String tableName) {
        return this.tableNameToValidTableNameMap.computeIfAbsent(tableName, Try.createFunctionWithThrow(k -> this.tableNameMapper.toValidTableName(tableName, this.connection.getMetaData()), OrmException::new));
    }

    private static ColumnsAndTypes createColumnsAndTypes(ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int colNum = metaData.getColumnCount();
        ArrayList<String> columns = new ArrayList<String>(colNum);
        ArrayList<Integer> columnTypes = new ArrayList<Integer>(colNum);
        for (int i = 1; i <= colNum; ++i) {
            columns.add(metaData.getColumnName(i));
            columnTypes.add(metaData.getColumnType(i));
        }
        return new ColumnsAndTypes(columns, columnTypes);
    }

    private static boolean isEnableToConvertNativeSqlType(Class<?> type) {
        return nativeSqlTypes.contains(type);
    }

    private static class ColumnsAndTypes {
        private final List<String> columns;
        private final List<Integer> columnTypes;

        public ColumnsAndTypes(List<String> columns, List<Integer> columnTypes) {
            this.columns = columns;
            this.columnTypes = columnTypes;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public List<Integer> getColumnTypes() {
            return this.columnTypes;
        }
    }
}

