/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.annotation.OrmColum;
import org.nkjmlab.sorm4j.annotation.OrmGetter;
import org.nkjmlab.sorm4j.annotation.OrmSetter;
import org.nkjmlab.sorm4j.mapping.Accessor;
import org.nkjmlab.sorm4j.mapping.Column;
import org.nkjmlab.sorm4j.mapping.ColumnToAccessorMap;
import org.nkjmlab.sorm4j.mapping.FieldName;
import org.nkjmlab.sorm4j.mapping.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.mapping.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.util.LoggerFactory;
import org.nkjmlab.sorm4j.util.StringUtils;
import org.slf4j.Logger;

abstract class Mapping<T> {
    private static final Logger log = LoggerFactory.getLogger();
    protected final Class<T> objectClass;
    protected final ResultSetConverter defaultResultSetConverter;
    protected final ColumnToAccessorMap columnToAccessorMap;

    Mapping(ResultSetConverter sqlToJavaConverter, Class<T> objectClass, ColumnFieldMapper columnFieldMapper) {
        this.defaultResultSetConverter = sqlToJavaConverter;
        this.objectClass = objectClass;
        this.columnToAccessorMap = Mapping.createColumnToAccessorMap(columnFieldMapper, objectClass);
    }

    Mapping(ResultSetConverter sqlToJavaConverter, Class<T> objectClass, List<Column> columns, ColumnFieldMapper columnFieldMapper) {
        this.defaultResultSetConverter = sqlToJavaConverter;
        this.objectClass = objectClass;
        this.columnToAccessorMap = Mapping.createColumnToAccessorMap(columnFieldMapper, objectClass, columns);
    }

    final Object getValue(Object object, String columnName) {
        Accessor acc = this.columnToAccessorMap.get(columnName);
        if (acc == null) {
            throw new OrmException(StringUtils.format("Error getting value from [{}] because column [{}] does not have a corresponding getter method or field access", object.getClass(), columnName));
        }
        try {
            return acc.get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new OrmException(StringUtils.format("Could not get a value from instance of [{}] for column [{}] with [{}] The instance is =[{}]", object == null ? "null" : object.getClass().getName(), columnName, acc.getFormattedString(), object), e);
        }
    }

    final void setValue(Object object, String columnName, Object value) {
        Accessor acc = this.columnToAccessorMap.get(columnName);
        if (acc == null) {
            throw new OrmException(StringUtils.format("Error setting value [{}] of type [{}] in [{}] because column [{}] does not have a corresponding setter method or field access =>[{}]", value, value.getClass().getSimpleName(), object.getClass().getName(), columnName, this.columnToAccessorMap.keySet()));
        }
        try {
            acc.set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new OrmException(StringUtils.format("Could not set a value for column [{}] to instance of [{}] with [{}]. The value is=[{}]", columnName, object == null ? "null" : object.getClass().getSimpleName(), acc.getFormattedString(), value), e);
        }
    }

    public String toString() {
        return "Mapping [objectClass=" + this.objectClass.getName() + ", columnToAccessorMap=" + this.columnToAccessorMap.values() + "]";
    }

    protected String getColumnToAccessorString() {
        List columnStrs = this.columnToAccessorMap.keySet().stream().sorted().collect(Collectors.toList());
        return "COLUMNS " + columnStrs + " is mapped to [" + this.objectClass.getName() + "]" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), columnStrs.stream().map(e -> "  COLUM " + e + " => " + this.columnToAccessorMap.get((String)e).getFormattedString()).collect(Collectors.toList()));
    }

    private static Map<String, Accessor> createAccessors(ColumnFieldMapper columnFieldMapper, List<Column> columns, Class<?> objectClass) {
        Map<FieldName, Field> fields = Mapping.getAllFields(objectClass);
        Map<FieldName, Method> getters = Mapping.getAllGetters(objectClass);
        Map<FieldName, Method> setters = Mapping.getAllSetters(objectClass);
        Map<Column, Field> annotatedFields = Mapping.getAnnotatedFieldsMap(objectClass);
        Map<Column, Method> annotatedGetters = Mapping.getAnnotatedGettersMap(objectClass);
        Map<Column, Method> annotatedSetters = Mapping.getAnnotatatedSettersMap(objectClass);
        ArrayList<FieldName> fieldsList = new ArrayList<FieldName>(fields.keySet());
        HashMap<String, Accessor> ret = new HashMap<String, Accessor>();
        for (Column column : columns) {
            Field f = annotatedFields.get(column);
            Method g = Mapping.isValidGetter(annotatedGetters.get(column));
            Method s = Mapping.isValidSetter(annotatedSetters.get(column));
            Optional<FieldName> op = columnFieldMapper.getFieldNameByColumnName(column, fieldsList);
            if (op.isPresent()) {
                FieldName fieldName = op.get();
                f = f != null ? f : fields.get(fieldName);
                g = g != null ? g : Mapping.isValidGetter(getters.get(fieldName));
                Method method = s = s != null ? g : Mapping.isValidSetter(setters.get(fieldName));
            }
            if (f == null && (g == null || s == null)) {
                log.debug("Skip matching with Column [{}] to field because could not found corresponding field.", (Object)column);
                continue;
            }
            ret.put(column.getName(), new Accessor(column, f, g, s));
        }
        return ret;
    }

    private static Map<FieldName, Method> extractedMethodStartWith(Class<?> objectClass, String prefix) {
        return Arrays.stream(objectClass.getDeclaredMethods()).filter(m -> m.getName().length() > prefix.length() && m.getName().substring(0, prefix.length()).equals(prefix)).collect(Collectors.toMap(m -> new FieldName(m.getName().substring(prefix.length(), prefix.length() + 1).toLowerCase() + m.getName().substring(prefix.length() + 1)), m -> m));
    }

    private static Map<FieldName, Field> getAllFields(Class<?> objectClass) {
        return Arrays.stream(objectClass.getDeclaredFields()).collect(Collectors.toMap(f -> new FieldName((Field)f), f -> {
            f.setAccessible(true);
            return f;
        }));
    }

    private static Map<FieldName, Method> getAllGetters(Class<?> objectClass) {
        Map<FieldName, Method> getters = Mapping.extractedMethodStartWith(objectClass, "get");
        return getters;
    }

    private static Map<FieldName, Method> getAllSetters(Class<?> objectClass) {
        Map<FieldName, Method> setters = Mapping.extractedMethodStartWith(objectClass, "set");
        return setters;
    }

    private static Map<Column, Method> getAnnotatatedSettersMap(Class<?> objectClass) {
        Class<OrmSetter> ann = OrmSetter.class;
        Map<Column, Method> annos = Arrays.stream(objectClass.getDeclaredMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann))).collect(Collectors.toMap(m -> new Column(((OrmSetter)m.getAnnotation(ann)).value()), m -> m));
        return annos;
    }

    private static Map<Column, Field> getAnnotatedFieldsMap(Class<?> objectClass) {
        Class<OrmColum> ann = OrmColum.class;
        return Arrays.stream(objectClass.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ann))).collect(Collectors.toMap(f -> new Column(((OrmColum)f.getAnnotation(ann)).value()), f -> {
            f.setAccessible(true);
            return f;
        }));
    }

    private static Map<Column, Method> getAnnotatedGettersMap(Class<?> objectClass) {
        Class<OrmGetter> ann = OrmGetter.class;
        Map<Column, Method> annos = Arrays.stream(objectClass.getDeclaredMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann))).collect(Collectors.toMap(m -> new Column(((OrmGetter)m.getAnnotation(ann)).value()), m -> m));
        return annos;
    }

    private static Method isValidGetter(Method getter) {
        if (getter == null) {
            return null;
        }
        if (getter.getParameterCount() != 0) {
            log.warn("Getter [{}] should not have parameter but has {} params.", (Object)getter, (Object)getter.getParameterCount());
            return null;
        }
        if (getter.getReturnType() == Void.TYPE) {
            log.warn("Getter [{}] must have return a parameter.");
        }
        return getter;
    }

    private static Method isValidSetter(Method setter) {
        if (setter == null) {
            return null;
        }
        if (setter.getParameterCount() != 1) {
            log.warn("Setter [{}] should have a single parameter but has {} params.", (Object)setter, (Object)setter.getParameterCount());
            return null;
        }
        return setter;
    }

    private static ColumnToAccessorMap createColumnToAccessorMap(ColumnFieldMapper columnFieldMapper, Class<?> objectClass) {
        return Mapping.createColumnToAccessorMap(columnFieldMapper, objectClass, Mapping.guessColumnNames(columnFieldMapper, objectClass));
    }

    private static ColumnToAccessorMap createColumnToAccessorMap(ColumnFieldMapper columnFieldMapper, Class<?> objectClass, List<Column> columns) {
        return new ColumnToAccessorMap(Mapping.createAccessors(columnFieldMapper, columns, objectClass));
    }

    private static List<Column> guessColumnNames(ColumnFieldMapper columnFieldMapper, Class<?> objectClass) {
        HashSet<FieldName> names = new HashSet<FieldName>();
        names.addAll(Mapping.getAllFields(objectClass).keySet());
        names.addAll(Mapping.getAllGetters(objectClass).keySet());
        names.addAll(Mapping.getAllSetters(objectClass).keySet());
        List<Column> columns = columnFieldMapper.getColumnNameCandidates(new ArrayList<FieldName>(names));
        columns.addAll(Mapping.getAnnotatedFieldsMap(objectClass).keySet());
        columns.addAll(Mapping.getAnnotatedGettersMap(objectClass).keySet());
        columns.addAll(Mapping.getAnnotatatedSettersMap(objectClass).keySet());
        return columns;
    }
}

