/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.nkjmlab.sorm4j.mapping.ColumnsMapping;
import org.nkjmlab.sorm4j.mapping.MultiRowProcessorGeneratorFactory;
import org.nkjmlab.sorm4j.mapping.OrmCache;
import org.nkjmlab.sorm4j.mapping.OrmConfigStoreBuilderImpl;
import org.nkjmlab.sorm4j.mapping.TableMapping;
import org.nkjmlab.sorm4j.mapping.TableName;
import org.nkjmlab.sorm4j.mapping.extension.ColumnFieldMapper;
import org.nkjmlab.sorm4j.mapping.extension.ResultSetConverter;
import org.nkjmlab.sorm4j.mapping.extension.SqlParameterSetter;
import org.nkjmlab.sorm4j.mapping.extension.TableNameMapper;

public final class OrmConfigStore {
    private static final ConcurrentMap<String, OrmConfigStore> configStores = new ConcurrentHashMap<String, OrmConfigStore>();
    public static final String DEFAULT_CONFIG_NAME = "DEFAULT_CONFIG";
    public static final OrmConfigStore INITIAL_DEFAULT_CONFIG_STORE = new OrmConfigStoreBuilderImpl("DEFAULT_CONFIG").build();
    private final String configName;
    private final ColumnFieldMapper columnFieldMapper;
    private final TableNameMapper tableNameMapper;
    private final ResultSetConverter resultSetConverter;
    private final SqlParameterSetter sqlParameterSetter;
    private final MultiRowProcessorGeneratorFactory multiProcessorFactory;
    public static final int DEFAULT_ISOLATION_LEVEL = 2;

    public OrmConfigStore(String cacheName, ColumnFieldMapper fieldNameMapper, TableNameMapper tableNameMapper, ResultSetConverter resultSetConverter, SqlParameterSetter javaToSqlConverter, MultiRowProcessorGeneratorFactory batchConfig) {
        this.configName = cacheName;
        this.columnFieldMapper = fieldNameMapper;
        this.tableNameMapper = tableNameMapper;
        this.resultSetConverter = resultSetConverter;
        this.sqlParameterSetter = javaToSqlConverter;
        this.multiProcessorFactory = batchConfig;
    }

    public String getConfigName() {
        return this.configName;
    }

    public ColumnFieldMapper getColumnFieldMapper() {
        return this.columnFieldMapper;
    }

    public ResultSetConverter getSqlToJavaDataConverter() {
        return this.resultSetConverter;
    }

    public TableNameMapper getTableNameMapper() {
        return this.tableNameMapper;
    }

    public MultiRowProcessorGeneratorFactory getMultiProcessorFactory() {
        return this.multiProcessorFactory;
    }

    public SqlParameterSetter getSqlParameterSetter() {
        return this.sqlParameterSetter;
    }

    public static OrmConfigStore refreshAndRegister(OrmConfigStore configStore) {
        OrmConfigStore.refresh(configStore.getConfigName());
        configStores.put(configStore.getConfigName(), configStore);
        return configStore;
    }

    public static OrmConfigStore get(String configName) {
        return (OrmConfigStore)configStores.get(configName);
    }

    public static OrmConfigStore getDefaultConfigStore() {
        return OrmConfigStore.get(DEFAULT_CONFIG_NAME);
    }

    public static void refresh(String configName) {
        OrmCache.refresh(configName);
    }

    public ConcurrentMap<String, TableMapping<?>> getTableMappings() {
        return OrmCache.getTableMappings(this.configName);
    }

    public ConcurrentMap<Class<?>, ColumnsMapping<?>> getColumnsMappings() {
        return OrmCache.getColumnsMappings(this.configName);
    }

    public ConcurrentMap<Class<?>, TableName> getClassNameToValidTableNameMap() {
        return OrmCache.getClassNameToValidTableNameMap(this.configName);
    }

    public ConcurrentMap<String, TableName> getTableNameToValidTableNameMaps() {
        return OrmCache.getTableNameToValidTableNameMaps(this.configName);
    }

    static {
        configStores.put(DEFAULT_CONFIG_NAME, INITIAL_DEFAULT_CONFIG_STORE);
    }
}

