/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.Connection;
import java.sql.SQLException;
import org.nkjmlab.sorm4j.ConnectionSource;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.Sorm;
import org.nkjmlab.sorm4j.SormFactory;
import org.nkjmlab.sorm4j.TypedOrmConnection;
import org.nkjmlab.sorm4j.mapping.OrmConfigStore;
import org.nkjmlab.sorm4j.mapping.OrmConnectionImpl;
import org.nkjmlab.sorm4j.mapping.TypedOrmConnectionImpl;

public final class SormImpl
implements Sorm {
    private final ConnectionSource connectionSource;
    private final OrmConfigStore configStore;

    public SormImpl(ConnectionSource connectionSource, OrmConfigStore configs) {
        this.configStore = configs;
        this.connectionSource = connectionSource;
    }

    @Override
    public OrmConnection beginTransaction() {
        return new OrmTransaction(this.getJdbcConnection(), this.configStore, 2);
    }

    @Override
    public <T> TypedOrmConnection<T> beginTransaction(Class<T> objectClass) {
        return new TypedOrmTransaction<T>(objectClass, this.getJdbcConnection(), this.configStore, 2);
    }

    @Override
    public <T> TypedOrmConnection<T> beginTransaction(Class<T> objectClass, int isolationLevel) {
        return new TypedOrmTransaction<T>(objectClass, this.getJdbcConnection(), this.configStore, isolationLevel);
    }

    @Override
    public OrmConnection beginTransaction(int isolationLevel) {
        return new OrmTransaction(this.getJdbcConnection(), this.configStore, isolationLevel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T, R> R execute(Class<T> objectClass, Sorm.OrmFunctionHandler<TypedOrmConnection<T>, R> handler) {
        try (TypedOrmConnection<T> conn = this.getConnection(objectClass);){
            R r = handler.apply(conn);
            return r;
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R execute(Sorm.OrmFunctionHandler<OrmConnection, R> handler) {
        try (OrmConnection conn = this.getConnection();){
            R r = handler.apply(conn);
            return r;
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T, R> R executeTransaction(Class<T> objectClass, Sorm.OrmFunctionHandler<TypedOrmConnection<T>, R> handler) {
        try (TypedOrmConnection<T> transaction = this.beginTransaction(objectClass);){
            R r = handler.apply(transaction);
            return r;
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T, R> R executeTransaction(Class<T> objectClass, int isolationLevel, Sorm.OrmFunctionHandler<TypedOrmConnection<T>, R> handler) {
        try (TypedOrmConnection<T> transaction = this.beginTransaction(objectClass, isolationLevel);){
            R r = handler.apply(transaction);
            return r;
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R executeTransaction(int isolationLevel, Sorm.OrmFunctionHandler<OrmConnection, R> handler) {
        try (OrmConnection transaction = this.beginTransaction();){
            R r = handler.apply(transaction);
            return r;
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R executeTransaction(Sorm.OrmFunctionHandler<OrmConnection, R> handler) {
        try (OrmConnection transaction = this.beginTransaction();){
            R r = handler.apply(transaction);
            return r;
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <R> R executeWithJdbcConnection(Sorm.OrmFunctionHandler<Connection, R> handler) {
        try (Connection conn = this.getJdbcConnection();){
            R r = handler.apply(conn);
            return r;
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    @Override
    public OrmConfigStore getConfigStore() {
        return this.configStore;
    }

    @Override
    public OrmConnection getConnection() {
        return SormFactory.getOrmConnection(this.getJdbcConnection(), this.configStore);
    }

    @Override
    public <T> TypedOrmConnection<T> getConnection(Class<T> objectClass) {
        return SormFactory.getTypedOrmConnection(this.getJdbcConnection(), objectClass, this.configStore);
    }

    @Override
    public ConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    @Override
    public Connection getJdbcConnection() {
        try {
            return this.connectionSource.getConnection();
        }
        catch (SQLException e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    @Override
    public <T> void run(Class<T> objectClass, Sorm.OrmConsumerHandler<TypedOrmConnection<T>> handler) {
        try (TypedOrmConnection<T> conn = this.getConnection(objectClass);){
            try {
                handler.accept(conn);
            }
            catch (Throwable e) {
                throw OrmException.wrapIfNotOrmException(e);
            }
        }
    }

    @Override
    public void run(Sorm.OrmConsumerHandler<OrmConnection> handler) {
        try (OrmConnection conn = this.getConnection();){
            handler.accept(conn);
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    @Override
    public <T> void runTransaction(Class<T> objectClass, Sorm.OrmConsumerHandler<TypedOrmConnection<T>> handler) {
        try (TypedOrmConnection<T> transaction = this.beginTransaction(objectClass);){
            handler.accept(transaction);
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    @Override
    public <T> void runTransaction(Class<T> objectClass, int isolationLevel, Sorm.OrmConsumerHandler<TypedOrmConnection<T>> handler) {
        try (TypedOrmConnection<T> transaction = this.beginTransaction(objectClass, isolationLevel);){
            handler.accept(transaction);
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    @Override
    public void runTransaction(Sorm.OrmConsumerHandler<OrmConnection> handler) {
        try (OrmConnection conn = this.beginTransaction();){
            handler.accept(conn);
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    @Override
    public void runTransaction(int isolationLevel, Sorm.OrmConsumerHandler<OrmConnection> handler) {
        try (OrmConnection conn = this.beginTransaction(isolationLevel);){
            handler.accept(conn);
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    @Override
    public void runWithJdbcConnection(Sorm.OrmConsumerHandler<Connection> handler) {
        try (Connection conn = this.getJdbcConnection();){
            handler.accept(conn);
        }
        catch (Throwable e) {
            throw OrmException.wrapIfNotOrmException(e);
        }
    }

    public String toString() {
        return "Sorm [connectionSource=" + this.connectionSource + ", configStore=" + this.configStore + "]";
    }

    private static class TypedOrmTransaction<T>
    extends TypedOrmConnectionImpl<T> {
        public TypedOrmTransaction(Class<T> objectClass, Connection connection, OrmConfigStore options, int isolationLevel) {
            super(objectClass, connection, options);
            this.begin(isolationLevel);
        }

        @Override
        public void close() {
            this.rollback();
            super.close();
        }
    }

    private static final class OrmTransaction
    extends OrmConnectionImpl {
        public OrmTransaction(Connection connection, OrmConfigStore options, int isolationLevel) {
            super(connection, options);
            this.begin(isolationLevel);
        }

        @Override
        public void close() {
            this.rollback();
            super.close();
        }
    }
}

