/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sqlstatement;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.TypedOrmConnection;

public class SelectBuilder {
    private boolean distinct;
    private String columns = "*";
    private String table;
    private String where;
    private String groupBy;
    private String having;
    private String orderBy;
    private String limit;

    private SelectBuilder() {
    }

    public static SelectBuilder create() {
        return new SelectBuilder();
    }

    public static Condition and(Object ... conds) {
        return new Condition("and", conds);
    }

    public static String as(String col, String aliase) {
        return col + " as " + aliase;
    }

    public static Condition cond(String cond) {
        return new Condition(cond);
    }

    public static Condition cond(String left, String op, String right) {
        return new Condition(left, op, right);
    }

    public static Condition or(Object ... conds) {
        return new Condition("or", conds);
    }

    public static OrderBy order(String column, String ascOrDesc) {
        return new OrderBy(column, ascOrDesc);
    }

    public static String q(String expr) {
        return "'" + expr + "'";
    }

    public SelectBuilder select(String ... columns) {
        this.columns = String.join((CharSequence)", ", Arrays.stream(columns).collect(Collectors.toList()));
        return this;
    }

    public SelectBuilder distinct() {
        this.distinct = true;
        return this;
    }

    public SelectBuilder from(String table) {
        this.table = table;
        return this;
    }

    public SelectBuilder from(TypedOrmConnection<?> orm) {
        this.table = orm.getTableName();
        return this;
    }

    public SelectBuilder groupBy(String ... columns) {
        this.groupBy = String.join((CharSequence)",", Arrays.stream(columns).collect(Collectors.toList()));
        return this;
    }

    public SelectBuilder having(Condition condition) {
        this.having(condition.toString());
        return this;
    }

    public SelectBuilder having(String expr) {
        this.having = expr;
        return this;
    }

    public SelectBuilder limit(int limit) {
        return this.limit(limit, 0);
    }

    public SelectBuilder limit(int limit, int offset) {
        this.limit = limit + (String)(offset > 0 ? " offset " + offset : "");
        return this;
    }

    public SelectBuilder orderBy(String column, String ascOrDesc) {
        this.orderBy(new OrderBy(column, ascOrDesc));
        return this;
    }

    public SelectBuilder orderBy(OrderBy ... orderBys) {
        this.orderBy = String.join((CharSequence)", ", Arrays.stream(orderBys).map(ob -> ob.toString()).collect(Collectors.toList()));
        return this;
    }

    public String build() {
        return this.toPrettyString(false);
    }

    public String toPrettyString() {
        return this.toPrettyString(true);
    }

    public String toPrettyString(boolean prettyPrint) {
        StringBuilder sql = new StringBuilder("select ");
        if (this.distinct) {
            sql.append("distinct ");
        }
        sql.append(this.columns);
        sql.append(prettyPrint ? System.lineSeparator() : "");
        sql.append(" from " + this.table);
        if (this.where != null) {
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(" where " + this.where);
        }
        if (this.groupBy != null) {
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(" group by " + this.groupBy);
        }
        if (this.having != null) {
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(" having " + this.having);
        }
        if (this.orderBy != null) {
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(" order by " + this.orderBy);
        }
        if (this.limit != null) {
            sql.append(prettyPrint ? System.lineSeparator() : "");
            sql.append(" limit " + this.limit);
        }
        return sql.toString();
    }

    public String toString() {
        return this.toPrettyString(false);
    }

    public SelectBuilder where(Condition condition) {
        this.where(condition.toString());
        return this;
    }

    public SelectBuilder where(String expr) {
        this.where = expr;
        return this;
    }

    public static class OrderBy {
        private final String column;
        private final String ascOrDesc;

        OrderBy(String column, String ascOrDesc) {
            this.column = column;
            this.ascOrDesc = ascOrDesc;
        }

        public String toString() {
            return this.column + " " + this.ascOrDesc;
        }
    }

    public static class Condition {
        private final Object condition;

        Condition(Object expr) {
            this.condition = expr;
        }

        Condition(String op, Object ... conds) {
            this("(" + String.join((CharSequence)(" " + op + " "), Arrays.stream(conds).map(c -> c.toString()).collect(Collectors.toList())) + ")");
        }

        Condition(String left, String op, String right) {
            this.condition = left + op + right;
        }

        public String toString() {
            return this.condition.toString();
        }
    }
}

