/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.sqlstatement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.nkjmlab.sorm4j.sqlstatement.SqlStatement;

public final class SqlWithOrderedParameters {
    private final String sql;
    private final List<Object> parameters = new ArrayList<Object>();

    private SqlWithOrderedParameters(String sql) {
        this.sql = sql;
    }

    public SqlWithOrderedParameters addAll(Object ... parameters) {
        Arrays.asList(parameters).forEach(v -> this.add(v));
        return this;
    }

    public SqlWithOrderedParameters add(Object parameter) {
        if (parameter instanceof List) {
            this.parameters.add(SqlStatement.literal(parameter));
        } else {
            this.parameters.add(parameter);
        }
        return this;
    }

    public SqlStatement toSqlStatement() {
        return SqlStatement.of(this.sql, this.parameters.toArray());
    }

    public static SqlWithOrderedParameters from(String sql) {
        return new SqlWithOrderedParameters(sql);
    }

    public static SqlStatement toSqlStatement(String sql, Object ... parameters) {
        return SqlWithOrderedParameters.from(sql).addAll(parameters).toSqlStatement();
    }
}

