/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.util;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class Try {
    private Try() {
    }

    public static Runnable createRunnable(ThrowableRunnable onTry, Consumer<Throwable> onCatch) {
        return () -> {
            try {
                onTry.run();
            }
            catch (Throwable e) {
                onCatch.accept(e);
            }
        };
    }

    public static <T> Supplier<T> createSupplier(ThrowableSupplier<T> onTry, Function<Throwable, T> onCatch) {
        return () -> {
            try {
                return onTry.get();
            }
            catch (Throwable e) {
                return onCatch.apply(e);
            }
        };
    }

    public static <T, X extends RuntimeException> Supplier<T> createSupplierWithThrow(ThrowableSupplier<T> onTry, Function<Throwable, ? extends X> ex) throws X {
        return Try.createSupplier(onTry, e -> {
            throw (RuntimeException)ex.apply((Throwable)e);
        });
    }

    public static <T, R> Consumer<T> createConsumer(ThrowableConsumer<T> onTry, Consumer<Throwable> onCatch) {
        return x -> {
            try {
                onTry.accept(x);
            }
            catch (Throwable e) {
                onCatch.accept(e);
            }
        };
    }

    public static <T, X extends RuntimeException> Consumer<T> createConsumerWithThrow(ThrowableConsumer<T> onTry, Function<Throwable, ? extends X> ex) throws X {
        return Try.createConsumer(onTry, e -> {
            throw (RuntimeException)ex.apply((Throwable)e);
        });
    }

    public static <T, R> Function<T, R> createFunction(ThrowableFunction<T, R> onTry, Function<Throwable, R> onCatch) {
        return x -> {
            try {
                return onTry.apply(x);
            }
            catch (Throwable e) {
                return onCatch.apply(e);
            }
        };
    }

    public static <T, S> BiConsumer<T, S> createBiConsumer(ThrowableBiConsumer<T, S> onTry, Consumer<Throwable> onCatch) {
        return (t, s) -> {
            try {
                onTry.accept(t, s);
            }
            catch (Throwable e) {
                onCatch.accept(e);
            }
        };
    }

    public static <T, R, X extends RuntimeException> Function<T, R> createFunctionWithThrow(ThrowableFunction<T, R> onTry, Function<Throwable, ? extends X> ex) throws X {
        return Try.createFunction(onTry, e -> {
            throw (RuntimeException)ex.apply((Throwable)e);
        });
    }

    public static <T, S, X extends RuntimeException> BiConsumer<T, S> createBiConsumerWithThrow(ThrowableBiConsumer<T, S> onTry, Function<Throwable, ? extends X> ex) throws X {
        return Try.createBiConsumer(onTry, e -> {
            throw (RuntimeException)ex.apply((Throwable)e);
        });
    }

    public static <T> T getOrNull(ThrowableSupplier<T> onTry) {
        return (T)Try.createSupplier(onTry, e -> null).get();
    }

    public static <T, X extends RuntimeException> T getOrThrow(ThrowableSupplier<T> onTry, Function<Throwable, ? extends X> ex) throws X {
        return (T)Try.createSupplier(onTry, e -> {
            throw (RuntimeException)ex.apply((Throwable)e);
        }).get();
    }

    public static <T, X extends RuntimeException> void runOrThrow(ThrowableRunnable onTry, Function<Throwable, ? extends X> ex) throws X {
        Try.createRunnable(onTry, e -> {
            throw (RuntimeException)ex.apply((Throwable)e);
        }).run();
    }

    @FunctionalInterface
    public static interface ThrowableBiConsumer<T, S> {
        public void accept(T var1, S var2) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowableFunction<T, R> {
        public R apply(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowableSupplier<T> {
        public T get() throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowableConsumer<T> {
        public void accept(T var1) throws Throwable;
    }

    @FunctionalInterface
    public static interface ThrowableRunnable {
        public void run() throws Throwable;
    }
}

