package org.nkjmlab.sorm4j.util;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.nkjmlab.sorm4j.OrmException;

public final class PreparedStatementUtils {

  public static PreparedStatement getPreparedStatement(Connection connection, String sql) {
    return Try.getOrThrow(() -> connection.prepareStatement(sql), e -> new OrmException(
        "Error creating prepared statement for sql [" + sql + "] : " + e.getMessage(), e));
  }

  public static PreparedStatement getPreparedStatement(Connection connection, String sql,
      String[] autoGeneratedKeys) {
    try {
      return (autoGeneratedKeys == null || autoGeneratedKeys.length == 0)
          ? connection.prepareStatement(sql)
          : connection.prepareStatement(sql, autoGeneratedKeys);
    } catch (SQLException e) {
      throw new OrmException(
          "Error creating prepared statement for sql [" + sql + "] with autoGeneratedKeys "
              + Arrays.toString(autoGeneratedKeys) + ": " + e.getMessage(),
          e);
    }
  }


}
