package org.nkjmlab.sorm4j.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.nkjmlab.sorm4j.mapping.Column;
import org.nkjmlab.sorm4j.mapping.FieldName;


public interface ColumnFieldMapper extends OrmConfig {

  List<Column> guessColumnNameCandidates(FieldName fieldName);

  Map<Column, Method> getAnnotatedGettersMap(Class<?> objectClass);

  Map<Column, Field> getAnnotatedFieldsMap(Class<?> objectClass);

  Map<Column, Method> getAnnotatatedSettersMap(Class<?> objectClass);

  /**
   * Get field name corresponding to the column name.
   *
   * @param column column name
   * @param fieldNames fieldNames exists in mapped object.
   * @return
   */
  Optional<FieldName> getFieldNameByColumnName(Column column, List<FieldName> fieldNames);

  /**
   * Get column name candidates based the field names.
   *
   * @param fieldNames
   * @return
   */
  List<Column> getColumnNameCandidates(List<FieldName> fieldNames);

  List<Column> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName);

  List<Column> getColumns(DatabaseMetaData metaData, String tableName);

  List<String> getPrimaryKeys(DatabaseMetaData metaData, String tableName);



}
