/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j;

import java.io.Closeable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.mapping.AbstractOrmMapper;

public final class LazyResultSet<T>
implements Iterable<T>,
Closeable,
AutoCloseable {
    private final Class<T> objectClass;
    private final AbstractOrmMapper ormMapper;
    private final ResultSet resultSet;
    private final PreparedStatement stmt;

    public LazyResultSet(AbstractOrmMapper ormMapper, Class<T> objectClass, PreparedStatement stmt, ResultSet resultSet) {
        this.ormMapper = ormMapper;
        this.objectClass = objectClass;
        this.stmt = stmt;
        this.resultSet = resultSet;
    }

    public T one() {
        T ret = this.ormMapper.loadOne(this.objectClass, this.resultSet);
        this.close();
        return ret;
    }

    public T first() {
        T ret = this.ormMapper.loadFirst(this.objectClass, this.resultSet);
        this.close();
        return ret;
    }

    public List<T> toList() {
        List<T> ret = this.ormMapper.loadPojoList(this.objectClass, this.resultSet);
        this.close();
        return ret;
    }

    public List<Map<String, Object>> toMapList() {
        List<Map<String, Object>> ret = this.ormMapper.loadMapList(this.resultSet);
        this.close();
        return ret;
    }

    @Override
    public Iterator<T> iterator() {
        return new LazyResultSetIterator<T>(this.ormMapper, this.objectClass, this.stmt, this.resultSet);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    @Override
    public void close() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException sQLException) {
        }
        finally {
            try {
                if (this.stmt != null) {
                    this.stmt.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private final class LazyResultSetIterator<S>
    implements Iterator<S> {
        private final Supplier<S> getFunction;

        public LazyResultSetIterator(AbstractOrmMapper orMapper, Class<S> objectClass, PreparedStatement stmt, ResultSet resultSet) {
            this.getFunction = objectClass.equals(Map.class) ? () -> orMapper.loadOneMap(resultSet) : () -> orMapper.loadOneObject(objectClass, resultSet);
        }

        @Override
        public boolean hasNext() {
            try {
                boolean hasNext = LazyResultSet.this.resultSet.next();
                if (!hasNext) {
                    LazyResultSet.this.close();
                }
                return hasNext;
            }
            catch (SQLException e) {
                LazyResultSet.this.close();
                throw new OrmException(e);
            }
        }

        @Override
        public S next() {
            return this.getFunction.get();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

