/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.sql.DataSource;
import org.nkjmlab.sorm4j.OrmConnection;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.TypedOrmConnection;
import org.nkjmlab.sorm4j.config.OrmConfigStore;
import org.nkjmlab.sorm4j.connectionsource.ConnectionSource;
import org.nkjmlab.sorm4j.connectionsource.DataSourceConnectionSource;
import org.nkjmlab.sorm4j.connectionsource.DriverManagerConnectionSource;
import org.nkjmlab.sorm4j.mapping.OrmTransaction;
import org.nkjmlab.sorm4j.mapping.TypedOrmTransaction;
import org.nkjmlab.sorm4j.util.LoggerFactory;
import org.slf4j.Logger;

public final class Sorm {
    private static final Logger log = LoggerFactory.getLogger();
    private final ConnectionSource connectionSource;
    private final OrmConfigStore configStore;

    public static Sorm of(ConnectionSource connectionSource, OrmConfigStore configs) {
        return new Sorm(connectionSource, configs);
    }

    public static Sorm of(ConnectionSource connectionSource) {
        return Sorm.of(connectionSource, OrmConfigStore.DEFAULT_CONFIGURATIONS);
    }

    public static Sorm of(DataSource dataSource) {
        return Sorm.of(dataSource, OrmConfigStore.DEFAULT_CONFIGURATIONS);
    }

    public static Sorm of(DataSource dataSource, OrmConfigStore configs) {
        return Sorm.of(new DataSourceConnectionSource(dataSource), configs);
    }

    public static Sorm of(String jdbcUrl, String user, String password) {
        return Sorm.of(jdbcUrl, user, password, OrmConfigStore.DEFAULT_CONFIGURATIONS);
    }

    public static Sorm of(String jdbcUrl, String user, String password, OrmConfigStore configs) {
        return Sorm.of(new DriverManagerConnectionSource(jdbcUrl, user, password), configs);
    }

    public static OrmConnection toOrmConnection(Connection conn) {
        return OrmConnection.of(conn);
    }

    public static <T> TypedOrmConnection<T> toTypedOrmConnection(Class<T> objectClass, Connection conn) {
        return TypedOrmConnection.of(objectClass, conn);
    }

    private Sorm(ConnectionSource connectionSource, OrmConfigStore configs) {
        this.configStore = configs;
        this.connectionSource = connectionSource;
    }

    public OrmTransaction beginTransaction() {
        return OrmTransaction.of(this.getJdbcConnection());
    }

    public <T> TypedOrmTransaction<T> beginTransaction(Class<T> objectClass) {
        return TypedOrmTransaction.of(objectClass, this.getJdbcConnection());
    }

    public OrmTransaction beginTransaction(int isolationLevel) {
        return OrmTransaction.of(this.getJdbcConnection(), isolationLevel);
    }

    public <T> TypedOrmTransaction<T> beginTransaction(Class<T> objectClass, int isolationLevel) {
        return TypedOrmTransaction.of(objectClass, this.getJdbcConnection(), isolationLevel);
    }

    public <T, R> R execute(Class<T> objectClass, Function<TypedOrmConnection<T>, R> handler) {
        try (TypedOrmConnection<T> conn = this.getConnection(objectClass);){
            R r = handler.apply(conn);
            return r;
        }
    }

    public <R> R execute(Function<OrmConnection, R> handler) {
        try (OrmConnection conn = this.getConnection();){
            R r = handler.apply(conn);
            return r;
        }
    }

    public <T, R> R executeTransaction(Class<T> objectClass, Function<TypedOrmTransaction<T>, R> handler) {
        try (TypedOrmTransaction<T> transaction = this.beginTransaction(objectClass);){
            R r = handler.apply(transaction);
            return r;
        }
    }

    public <R> R executeTransaction(Function<OrmTransaction, R> handler) {
        try (OrmTransaction transaction = this.beginTransaction();){
            R r = handler.apply(transaction);
            return r;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <R> R executeWithJdbcConnection(Function<Connection, R> handler) {
        try (Connection conn = this.getJdbcConnection();){
            R r = handler.apply(conn);
            return r;
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    public OrmConnection getConnection() {
        return OrmConnection.of(this.getJdbcConnection());
    }

    public <T> TypedOrmConnection<T> getConnection(Class<T> objectClass) {
        return TypedOrmConnection.of(objectClass, this.getJdbcConnection());
    }

    public Connection getJdbcConnection() {
        try {
            return this.connectionSource.getConnection();
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    public <T> void run(Class<T> objectClass, Consumer<TypedOrmConnection<T>> handler) {
        try (TypedOrmConnection<T> conn = this.getConnection(objectClass);){
            handler.accept(conn);
        }
    }

    public void run(Consumer<OrmConnection> handler) {
        try (OrmConnection conn = this.getConnection();){
            handler.accept(conn);
        }
    }

    public <T> void runTransaction(Class<T> objectClass, Consumer<TypedOrmTransaction<T>> handler) {
        try (TypedOrmTransaction<T> transaction = this.beginTransaction(objectClass);){
            handler.accept(transaction);
        }
    }

    public void runTransaction(Consumer<OrmTransaction> handler) {
        try (OrmTransaction conn = this.beginTransaction();){
            handler.accept(conn);
        }
    }

    public void runWithJdbcConnection(Consumer<Connection> handler) {
        try (Connection conn = this.getJdbcConnection();){
            handler.accept(conn);
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    public String toString() {
        return "OrmService [connectionSource=" + this.connectionSource + ", configStore=" + this.configStore + "]";
    }
}

