/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.annotation.OrmColum;
import org.nkjmlab.sorm4j.annotation.OrmGetter;
import org.nkjmlab.sorm4j.annotation.OrmSetter;
import org.nkjmlab.sorm4j.config.ColumnFieldMapper;
import org.nkjmlab.sorm4j.mapping.Column;
import org.nkjmlab.sorm4j.mapping.ColumnOnTable;
import org.nkjmlab.sorm4j.mapping.FieldName;
import org.nkjmlab.sorm4j.util.StringUtils;

public final class DefaultColumnFieldMapper
implements ColumnFieldMapper {
    @Override
    public List<Column> guessColumnNameCandidates(FieldName fieldName) {
        return List.of(new Column(StringUtils.toUpperSnakeCase(fieldName.getName())));
    }

    @Override
    public Map<Column, Field> getAnnotatedFieldsMap(Class<?> objectClass) {
        Class<OrmColum> ann = OrmColum.class;
        return Arrays.stream(objectClass.getDeclaredFields()).filter(f -> Objects.nonNull(f.getAnnotation(ann))).collect(Collectors.toMap(f -> new Column(((OrmColum)f.getAnnotation(ann)).value()), f -> {
            f.setAccessible(true);
            return f;
        }));
    }

    @Override
    public Map<Column, Method> getAnnotatatedSettersMap(Class<?> objectClass) {
        Class<OrmSetter> ann = OrmSetter.class;
        Map<Column, Method> annos = Arrays.stream(objectClass.getDeclaredMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann))).collect(Collectors.toMap(m -> new Column(((OrmSetter)m.getAnnotation(ann)).value()), m -> m));
        return annos;
    }

    @Override
    public Map<Column, Method> getAnnotatedGettersMap(Class<?> objectClass) {
        Class<OrmGetter> ann = OrmGetter.class;
        Map<Column, Method> annos = Arrays.stream(objectClass.getDeclaredMethods()).filter(m -> Objects.nonNull(m.getAnnotation(ann))).collect(Collectors.toMap(m -> new Column(((OrmGetter)m.getAnnotation(ann)).value()), m -> m));
        return annos;
    }

    @Override
    public Optional<FieldName> getFieldNameByColumnName(Column column, List<FieldName> fieldNames) {
        for (FieldName fieldName : fieldNames) {
            if (!StringUtils.containsIgnoreCase(this.guessColumnNameCandidates(fieldName).stream().map(s -> s.toString()).collect(Collectors.toList()), column.getName())) continue;
            return Optional.of(fieldName);
        }
        return Optional.empty();
    }

    @Override
    public List<Column> getColumnNameCandidates(List<FieldName> fieldNames) {
        return fieldNames.stream().flatMap(fieldName -> this.guessColumnNameCandidates((FieldName)fieldName).stream()).collect(Collectors.toList());
    }

    @Override
    public List<Column> getAutoGeneratedColumns(DatabaseMetaData metaData, String tableName) {
        ArrayList<Column> arrayList;
        block9: {
            ResultSet resultSet = metaData.getColumns(null, this.getSchemaPattern(metaData), tableName, "%");
            try {
                ArrayList<Column> columnsList = new ArrayList<Column>();
                while (resultSet.next()) {
                    String columnName = resultSet.getString(4);
                    String isAutoIncrement = resultSet.getString(23);
                    if (!isAutoIncrement.equals("YES")) continue;
                    columnsList.add(new Column(columnName));
                }
                arrayList = columnsList;
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OrmException(e);
                }
            }
            resultSet.close();
        }
        return arrayList;
    }

    @Override
    public List<Column> getColumns(DatabaseMetaData metaData, String tableName) {
        ArrayList<Column> arrayList;
        block9: {
            ResultSet resultSet = metaData.getColumns(null, this.getSchemaPattern(metaData), tableName, "%");
            try {
                ArrayList<Column> columnsList = new ArrayList<Column>();
                while (resultSet.next()) {
                    String columnName = resultSet.getString(4);
                    int dataType = resultSet.getInt(5);
                    columnsList.add(new ColumnOnTable(columnName, dataType));
                }
                arrayList = columnsList;
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OrmException(e);
                }
            }
            resultSet.close();
        }
        return arrayList;
    }

    @Override
    public List<String> getPrimaryKeys(DatabaseMetaData metaData, String tableName) {
        ArrayList<String> arrayList;
        block9: {
            ArrayList<String> primaryKeysList = new ArrayList<String>();
            ResultSet resultSet = metaData.getPrimaryKeys(null, this.getSchemaPattern(metaData), tableName);
            try {
                while (resultSet.next()) {
                    String columnName = resultSet.getString(4);
                    primaryKeysList.add(columnName);
                }
                arrayList = primaryKeysList;
                if (resultSet == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new OrmException(e);
                }
            }
            resultSet.close();
        }
        return arrayList;
    }

    private String getSchemaPattern(DatabaseMetaData metaData) throws SQLException {
        if ("Oracle".equalsIgnoreCase(metaData.getDatabaseProductName())) {
            return "%";
        }
        return null;
    }
}

