/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.config;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.nkjmlab.sorm4j.config.PreparedStatementParametersSetter;
import org.nkjmlab.sorm4j.util.LoggerFactory;
import org.slf4j.Logger;

public final class DefaultPreparedStatementParametersSetter
implements PreparedStatementParametersSetter {
    private static Logger log = LoggerFactory.getLogger();

    @Override
    public void setParameters(PreparedStatement stmt, Object ... parameters) throws SQLException {
        if (parameters == null || parameters.length == 0) {
            return;
        }
        ParameterMetaData metaData = null;
        for (int i = 1; i <= parameters.length; ++i) {
            Object parameter = parameters[i - 1];
            if (parameter == null) {
                metaData = metaData == null ? stmt.getParameterMetaData() : metaData;
                stmt.setNull(i, metaData.getParameterType(i));
                continue;
            }
            this.setParameter(stmt, i, parameter);
        }
    }

    @Override
    public void setParameter(PreparedStatement stmt, int column, Object parameter) throws SQLException {
        Class<?> type = parameter.getClass();
        if (type.isEnum()) {
            stmt.setString(column, parameter.toString());
        } else if (type.isArray()) {
            this.procArray(type, stmt, column, parameter);
        } else {
            this.procObject(type, stmt, column, parameter);
        }
    }

    private final void procObject(Class<?> type, PreparedStatement stmt, int column, Object parameter) throws SQLException {
        String typeName;
        if (parameter instanceof Clob) {
            stmt.setClob(column, (Clob)parameter);
        } else if (parameter instanceof Blob) {
            stmt.setBlob(column, (Blob)parameter);
        }
        switch (typeName = type.getName()) {
            case "java.lang.Boolean": 
            case "boolean": {
                stmt.setBoolean(column, (Boolean)parameter);
                return;
            }
            case "java.lang.Byte": 
            case "byte": {
                stmt.setByte(column, (Byte)parameter);
                return;
            }
            case "java.lang.Short": 
            case "short": {
                stmt.setShort(column, (Short)parameter);
                return;
            }
            case "java.lang.Integer": 
            case "int": {
                stmt.setInt(column, (Integer)parameter);
                return;
            }
            case "java.lang.Long": 
            case "long": {
                stmt.setLong(column, (Long)parameter);
                return;
            }
            case "java.lang.Float": 
            case "float": {
                stmt.setFloat(column, ((Float)parameter).floatValue());
                return;
            }
            case "java.lang.Double": 
            case "double": {
                stmt.setDouble(column, (Double)parameter);
                return;
            }
            case "java.lang.Character": 
            case "char": {
                stmt.setString(column, parameter == null ? null : "" + (Character)parameter);
                return;
            }
            case "java.lang.String": {
                stmt.setString(column, (String)parameter);
                return;
            }
            case "java.math.BigDecimal": {
                stmt.setBigDecimal(column, (BigDecimal)parameter);
                return;
            }
            case "java.sql.Date": {
                stmt.setDate(column, Date.valueOf(parameter.toString()));
                return;
            }
            case "java.sql.Time": {
                stmt.setTime(column, Time.valueOf(parameter.toString()));
                return;
            }
            case "java.sql.Timestamp": {
                stmt.setTimestamp(column, (Timestamp)parameter);
                return;
            }
            case "java.time.LocalTime": {
                stmt.setTime(column, Time.valueOf((LocalTime)parameter));
                return;
            }
            case "java.time.LocalDate": {
                stmt.setDate(column, Date.valueOf((LocalDate)parameter));
                return;
            }
            case "java.time.LocalDateTime": {
                stmt.setTimestamp(column, Timestamp.valueOf((LocalDateTime)parameter));
                return;
            }
        }
        stmt.setObject(column, parameter);
    }

    private final void procArray(Class<?> type, PreparedStatement stmt, int column, Object parameter) throws SQLException {
        String name;
        switch (name = type.getComponentType().getName()) {
            case "char": {
                stmt.setString(column, parameter == null ? null : String.valueOf((char[])parameter));
                return;
            }
            case "java.lang.Character": {
                Character[] src = (Character[])parameter;
                char[] dst = new char[src.length];
                for (int j = 0; j < src.length; ++j) {
                    dst[j] = src[j].charValue();
                }
                stmt.setString(column, String.valueOf(dst));
                return;
            }
            case "byte": {
                stmt.setBytes(column, (byte[])parameter);
                return;
            }
            case "java.lang.Byte": {
                Byte[] src = (Byte[])parameter;
                byte[] dst = new byte[src.length];
                for (int j = 0; j < src.length; ++j) {
                    dst[j] = src[j];
                }
                stmt.setBytes(column, dst);
                return;
            }
        }
    }
}

