/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.config;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.nkjmlab.sorm4j.config.ResultSetValueGetter;
import org.nkjmlab.sorm4j.util.LoggerFactory;
import org.slf4j.Logger;

public final class DefaultResultSetValueGetter
implements ResultSetValueGetter {
    private static Logger log = LoggerFactory.getLogger();
    public static final Map<Integer, String> typeStringMap = DefaultResultSetValueGetter.initalizeTypeStringMap();

    @Override
    public Object getValueByClass(ResultSet resultSet, int column, Class<?> type) throws SQLException {
        String name;
        if (type.isEnum()) {
            String v = resultSet.getString(column);
            return Arrays.stream(type.getEnumConstants()).filter(o -> o.toString().equals(v)).findAny().orElse(null);
        }
        if (type.isArray()) {
            switch (name = type.getComponentType().getName()) {
                case "byte": 
                case "java.lang.Byte": {
                    return resultSet.getBytes(column);
                }
                case "char": 
                case "java.lang.Character": {
                    String str = resultSet.getString(column);
                    return str == null ? null : str.toCharArray();
                }
            }
        }
        switch (name = type.getName()) {
            case "boolean": {
                return resultSet.getBoolean(column);
            }
            case "java.lang.Boolean": {
                boolean ret = resultSet.getBoolean(column);
                return !ret && resultSet.wasNull() ? null : Boolean.valueOf(ret);
            }
            case "byte": {
                return resultSet.getByte(column);
            }
            case "java.lang.Byte": {
                byte ret = resultSet.getByte(column);
                return ret == 0 && resultSet.wasNull() ? null : Byte.valueOf(ret);
            }
            case "short": {
                return resultSet.getShort(column);
            }
            case "java.lang.Short": {
                short ret = resultSet.getShort(column);
                return ret == 0 && resultSet.wasNull() ? null : Short.valueOf(ret);
            }
            case "int": {
                return resultSet.getInt(column);
            }
            case "java.lang.Integer": {
                int ret = resultSet.getInt(column);
                return ret == 0 && resultSet.wasNull() ? null : Integer.valueOf(ret);
            }
            case "long": {
                return resultSet.getLong(column);
            }
            case "java.lang.Long": {
                long ret = resultSet.getLong(column);
                return ret == 0L && resultSet.wasNull() ? null : Long.valueOf(ret);
            }
            case "float": {
                return Float.valueOf(resultSet.getFloat(column));
            }
            case "java.lang.Float": {
                float ret = resultSet.getFloat(column);
                return ret == 0.0f && resultSet.wasNull() ? null : Float.valueOf(ret);
            }
            case "double": {
                return resultSet.getDouble(column);
            }
            case "java.lang.Double": {
                double ret = resultSet.getDouble(column);
                return ret == 0.0 && resultSet.wasNull() ? null : Double.valueOf(ret);
            }
            case "java.math.BigDecimal": {
                return resultSet.getBigDecimal(column);
            }
            case "java.lang.String": {
                return resultSet.getString(column);
            }
            case "java.lang.Character": 
            case "char": {
                String str = resultSet.getString(column);
                return str == null || str.length() == 0 ? null : Character.valueOf(str.charAt(0));
            }
            case "java.sql.Date": {
                return resultSet.getDate(column);
            }
            case "java.sql.Time": {
                return resultSet.getTime(column);
            }
            case "java.sql.Timestamp": {
                return resultSet.getTimestamp(column);
            }
            case "java.io.InputStream": {
                return resultSet.getBinaryStream(column);
            }
            case "java.io.Reader": {
                return resultSet.getCharacterStream(column);
            }
            case "java.sql.Clob": {
                return resultSet.getClob(column);
            }
            case "java.sql.Blob": {
                return resultSet.getBlob(column);
            }
            case "java.time.LocalTime": {
                return resultSet.getTime(column).toLocalTime();
            }
            case "java.time.LocalDate": {
                return resultSet.getDate(column).toLocalDate();
            }
            case "java.time.LocalDateTime": {
                return resultSet.getTimestamp(column).toLocalDateTime();
            }
            case "java.lang.Object": {
                return resultSet.getObject(column);
            }
        }
        log.warn("Could not find coresponding converter for type [{}] on column [{}]. ResultSet.getObject method will be used.", (Object)name, (Object)column);
        return resultSet.getObject(column);
    }

    @Override
    public Object getValueBySqlType(ResultSet resultSet, int column, int type) throws SQLException {
        switch (type) {
            case 2003: {
                return resultSet.getArray(column);
            }
            case -5: {
                long ret = resultSet.getLong(column);
                return ret == 0L && resultSet.wasNull() ? null : Long.valueOf(ret);
            }
            case -2: {
                return resultSet.getBytes(column);
            }
            case -7: {
                boolean ret = resultSet.getBoolean(column);
                return !ret && resultSet.wasNull() ? null : Boolean.valueOf(ret);
            }
            case 2004: {
                return resultSet.getBytes(column);
            }
            case 16: {
                boolean ret = resultSet.getBoolean(column);
                return !ret && resultSet.wasNull() ? null : Boolean.valueOf(ret);
            }
            case 1: {
                return resultSet.getString(column);
            }
            case 2005: {
                return resultSet.getString(column);
            }
            case 70: {
                return resultSet.getBinaryStream(column);
            }
            case 91: {
                return resultSet.getDate(column);
            }
            case 3: {
                return resultSet.getBigDecimal(column);
            }
            case 8: {
                double ret = resultSet.getDouble(column);
                return ret == 0.0 && resultSet.wasNull() ? null : Double.valueOf(ret);
            }
            case 6: {
                float ret = resultSet.getFloat(column);
                return ret == 0.0f && resultSet.wasNull() ? null : Float.valueOf(ret);
            }
            case 4: {
                int ret = resultSet.getInt(column);
                return ret == 0 && resultSet.wasNull() ? null : Integer.valueOf(ret);
            }
            case 2000: {
                return resultSet.getObject(column);
            }
            case -4: {
                return resultSet.getBytes(column);
            }
            case -1: {
                return resultSet.getString(column);
            }
            case 0: {
                return null;
            }
            case 2: {
                return resultSet.getBigDecimal(column);
            }
            case 1111: {
                return resultSet.getObject(column);
            }
            case 7: {
                double ret = resultSet.getDouble(column);
                return ret == 0.0 && resultSet.wasNull() ? null : Double.valueOf(ret);
            }
            case 2006: {
                return resultSet.getRef(column);
            }
            case -8: {
                return resultSet.getRowId(column);
            }
            case 5: {
                short ret = (short)resultSet.getInt(column);
                return ret == 0 && resultSet.wasNull() ? null : Short.valueOf(ret);
            }
            case 92: {
                return resultSet.getTime(column);
            }
            case 93: {
                return resultSet.getTimestamp(column);
            }
            case -6: {
                byte ret = resultSet.getByte(column);
                return ret == 0 && resultSet.wasNull() ? null : Byte.valueOf(ret);
            }
            case -3: {
                return resultSet.getBytes(column);
            }
            case 12: {
                return resultSet.getString(column);
            }
        }
        log.warn("Could not get value for result set using type [{}] on column [{}]. ResultSet.getObject method will be used.", (Object)DefaultResultSetValueGetter.sqlTypeToString(type), (Object)column);
        return resultSet.getObject(column);
    }

    public static String sqlTypeToString(int type) {
        return typeStringMap.getOrDefault(type, "");
    }

    private static Map<Integer, String> initalizeTypeStringMap() {
        HashMap<Integer, String> typeStringMap = new HashMap<Integer, String>();
        typeStringMap.put(2003, "ARRAY");
        typeStringMap.put(-5, "BIGINT");
        typeStringMap.put(-2, "BINARY");
        typeStringMap.put(-7, "BIT");
        typeStringMap.put(2004, "BLOB");
        typeStringMap.put(16, "BOOLEAN");
        typeStringMap.put(1, "CHAR");
        typeStringMap.put(2005, "CLOB");
        typeStringMap.put(70, "DATALINK");
        typeStringMap.put(91, "DATE");
        typeStringMap.put(3, "DECIMAL");
        typeStringMap.put(2001, "DISTINCT");
        typeStringMap.put(8, "DOUBLE");
        typeStringMap.put(6, "FLOAT");
        typeStringMap.put(4, "INTEGER");
        typeStringMap.put(2000, "JAVA_OBJECT");
        typeStringMap.put(-4, "LONGVARBINARY");
        typeStringMap.put(-1, "LONGVARCHAR");
        typeStringMap.put(0, "NULL");
        typeStringMap.put(2, "NUMERIC");
        typeStringMap.put(1111, "OTHER");
        typeStringMap.put(7, "REAL");
        typeStringMap.put(2006, "REF");
        typeStringMap.put(-8, "ROWID");
        typeStringMap.put(5, "SMALLINT");
        typeStringMap.put(2002, "STRUCT");
        typeStringMap.put(92, "TIME");
        typeStringMap.put(93, "TIMESTAMP");
        typeStringMap.put(-6, "TINYINT");
        typeStringMap.put(-3, "VARBINARY");
        typeStringMap.put(12, "VARCHAR");
        return typeStringMap;
    }
}

