/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.config;

import org.nkjmlab.sorm4j.config.ColumnFieldMapper;
import org.nkjmlab.sorm4j.config.DefaultColumnFieldMapper;
import org.nkjmlab.sorm4j.config.DefaultPreparedStatementParametersSetter;
import org.nkjmlab.sorm4j.config.DefaultResultSetValueGetter;
import org.nkjmlab.sorm4j.config.DefaultTableNameGuesser;
import org.nkjmlab.sorm4j.config.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.config.PreparedStatementParametersSetter;
import org.nkjmlab.sorm4j.config.ResultSetValueGetter;
import org.nkjmlab.sorm4j.config.TableNameMapper;

public final class OrmConfigStore {
    public static final String DEFAULT_CACHE = "DEFAULT_CACHE";
    public static final ColumnFieldMapper DEFAULT_COLUMN_FIELD_MAPPER = new DefaultColumnFieldMapper();
    public static final TableNameMapper DEFAULT_TABLE_NAME_MAPPER = new DefaultTableNameGuesser();
    public static final ResultSetValueGetter DEFAULT_SQL_TO_JAVA_DATA_CONVERTER = new DefaultResultSetValueGetter();
    public static final PreparedStatementParametersSetter DEFAULT_JAVA_TO_SQL_DATA_CONVERTER = new DefaultPreparedStatementParametersSetter();
    public static final MultiRowProcessorFactory DEFAULT_MULTI_ROW_PROCESSOR_FACTORY = new MultiRowProcessorFactory();
    private final String cacheName;
    private final ColumnFieldMapper columnFieldMapper;
    private final TableNameMapper tableNameMapper;
    private final ResultSetValueGetter resultSetValueGetter;
    private final PreparedStatementParametersSetter preparedStatementParametersSetter;
    private final MultiRowProcessorFactory multiProcessorFactory;
    public static final int DEFAULT_ISOLATION_LEVEL = 2;
    public static final OrmConfigStore DEFAULT_CONFIGURATIONS = new OrmConfigStore();

    public OrmConfigStore() {
        this(DEFAULT_CACHE, DEFAULT_COLUMN_FIELD_MAPPER, DEFAULT_TABLE_NAME_MAPPER, DEFAULT_SQL_TO_JAVA_DATA_CONVERTER, DEFAULT_JAVA_TO_SQL_DATA_CONVERTER, DEFAULT_MULTI_ROW_PROCESSOR_FACTORY);
    }

    public OrmConfigStore(String cacheName, ColumnFieldMapper fieldNameMapper, TableNameMapper tableNameMapper, ResultSetValueGetter sqlToJavaConverter, PreparedStatementParametersSetter javaToSqlConverter, MultiRowProcessorFactory batchConfig) {
        this.cacheName = cacheName;
        this.columnFieldMapper = fieldNameMapper;
        this.tableNameMapper = tableNameMapper;
        this.resultSetValueGetter = sqlToJavaConverter;
        this.preparedStatementParametersSetter = javaToSqlConverter;
        this.multiProcessorFactory = batchConfig;
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public ColumnFieldMapper getColumnFieldMapper() {
        return this.columnFieldMapper;
    }

    public ResultSetValueGetter getSqlToJavaDataConverter() {
        return this.resultSetValueGetter;
    }

    public TableNameMapper getTableNameMapper() {
        return this.tableNameMapper;
    }

    public MultiRowProcessorFactory getMultiProcessorFactory() {
        return this.multiProcessorFactory;
    }

    public PreparedStatementParametersSetter getJavaToSqlDataConverter() {
        return this.preparedStatementParametersSetter;
    }

    public static Builder createBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String cacheName = "DEFAULT_CACHE";
        private ColumnFieldMapper columnFieldMapper = DEFAULT_COLUMN_FIELD_MAPPER;
        private TableNameMapper tableNameMapper = DEFAULT_TABLE_NAME_MAPPER;
        private ResultSetValueGetter resultSetValueGetter = DEFAULT_SQL_TO_JAVA_DATA_CONVERTER;
        private PreparedStatementParametersSetter preparedStatementParametersSetter = DEFAULT_JAVA_TO_SQL_DATA_CONVERTER;
        private MultiRowProcessorFactory multiRowProcessorFactory = DEFAULT_MULTI_ROW_PROCESSOR_FACTORY;

        public OrmConfigStore build() {
            return new OrmConfigStore(this.cacheName, this.columnFieldMapper, this.tableNameMapper, this.resultSetValueGetter, this.preparedStatementParametersSetter, this.multiRowProcessorFactory);
        }

        public Builder setCacheName(String cacheName) {
            this.cacheName = cacheName;
            return this;
        }

        public Builder setColumnFieldMapper(ColumnFieldMapper fieldNameMapper) {
            this.columnFieldMapper = fieldNameMapper;
            return this;
        }

        public Builder setTableNameMapper(TableNameMapper tableNameMapper) {
            this.tableNameMapper = tableNameMapper;
            return this;
        }

        public Builder setSqlToJavaDataConverter(ResultSetValueGetter resultSetValueGetter) {
            this.resultSetValueGetter = resultSetValueGetter;
            return this;
        }

        public Builder setJavaToSqlDataConverter(PreparedStatementParametersSetter preparedStatementParametersSetter) {
            this.preparedStatementParametersSetter = preparedStatementParametersSetter;
            return this;
        }

        public Builder setMultiRowProcessorFactory(MultiRowProcessorFactory batchConfig) {
            this.multiRowProcessorFactory = batchConfig;
            return this;
        }
    }
}

