/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.nkjmlab.sorm4j.LazyResultSet;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.SqlExecutor;
import org.nkjmlab.sorm4j.config.ColumnFieldMapper;
import org.nkjmlab.sorm4j.config.MultiRowProcessorFactory;
import org.nkjmlab.sorm4j.config.OrmConfigStore;
import org.nkjmlab.sorm4j.config.PreparedStatementParametersSetter;
import org.nkjmlab.sorm4j.config.TableNameMapper;
import org.nkjmlab.sorm4j.mapping.ColumnsMapping;
import org.nkjmlab.sorm4j.mapping.ResultSetConverter;
import org.nkjmlab.sorm4j.mapping.TableMapping;
import org.nkjmlab.sorm4j.mapping.TableName;
import org.nkjmlab.sorm4j.util.DebugPoint;
import org.nkjmlab.sorm4j.util.DebugPointFactory;
import org.nkjmlab.sorm4j.util.LoggerFactory;
import org.nkjmlab.sorm4j.util.PreparedStatementUtils;
import org.nkjmlab.sorm4j.util.StringUtils;
import org.nkjmlab.sorm4j.util.Try;
import org.slf4j.Logger;

public abstract class AbstractOrmMapper
implements SqlExecutor {
    private static final Logger log = LoggerFactory.getLogger();
    private static final ConcurrentMap<Class<?>, TableName> classNameToValidTableNameMap = new ConcurrentHashMap();
    private static final ConcurrentMap<String, TableName> tableNameToValidTableNameMap = new ConcurrentHashMap<String, TableName>();
    private final ColumnFieldMapper fieldMapper;
    private final TableNameMapper tableNameMapper;
    private final ResultSetConverter sqlToJavaConverter;
    private final PreparedStatementParametersSetter javaToSqlConverter;
    private final ConcurrentMap<String, TableMapping<?>> tableMappings;
    private final ConcurrentMap<Class<?>, ColumnsMapping<?>> columnsMappings;
    private final Connection connection;
    private final MultiRowProcessorFactory batchConfig;
    private final OrmConfigStore configStore;
    private static final ConcurrentMap<String, ConcurrentMap<String, TableMapping<?>>> tableMappingsCaches = new ConcurrentHashMap();
    private static final ConcurrentMap<String, ConcurrentMap<Class<?>, ColumnsMapping<?>>> columnsMappingsCaches = new ConcurrentHashMap();
    private static final Set<Class<?>> nativeSqlTypes = Set.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Character.TYPE, Character.class, byte[].class, Byte[].class, char[].class, Character[].class, String.class, BigDecimal.class, java.util.Date.class, Date.class, Time.class, Timestamp.class, InputStream.class, Reader.class, Clob.class, Blob.class, Object.class);

    private static ConcurrentMap<String, TableMapping<?>> getTableMappings(String cacheName) {
        return tableMappingsCaches.computeIfAbsent(cacheName, n -> new ConcurrentHashMap());
    }

    private static ConcurrentMap<Class<?>, ColumnsMapping<?>> getColumnsMappings(String cacheName) {
        return columnsMappingsCaches.computeIfAbsent(cacheName, n -> new ConcurrentHashMap());
    }

    public AbstractOrmMapper(Connection connection, OrmConfigStore configStore) {
        this.connection = connection;
        this.configStore = configStore;
        this.batchConfig = configStore.getMultiProcessorFactory();
        this.fieldMapper = configStore.getColumnFieldMapper();
        this.tableNameMapper = configStore.getTableNameMapper();
        this.sqlToJavaConverter = new ResultSetConverter(configStore.getSqlToJavaDataConverter());
        this.javaToSqlConverter = configStore.getJavaToSqlDataConverter();
        String cacheName = configStore.getCacheName();
        this.tableMappings = AbstractOrmMapper.getTableMappings(cacheName);
        this.columnsMappings = AbstractOrmMapper.getColumnsMappings(cacheName);
    }

    public <T> TableMapping<T> getTableMapping(Class<T> objectClass) {
        TableName tableName = this.toTableName(objectClass);
        return this.getTableMapping(tableName, objectClass);
    }

    <T> TableMapping<T> getTableMapping(String tableName, Class<T> objectClass) {
        return this.getTableMapping(this.toTableName(tableName), objectClass);
    }

    <T> TableMapping<T> getTableMapping(TableName tableName, Class<T> objectClass) {
        String key = tableName.getName() + "-" + objectClass.getName();
        TableMapping ret = this.tableMappings.computeIfAbsent(key, Try.createFunctionWithThrow(_key -> {
            TableMapping m = TableMapping.createMapping(this.sqlToJavaConverter, this.javaToSqlConverter, objectClass, tableName.getName(), this.fieldMapper, this.batchConfig, this.connection);
            log.debug(System.lineSeparator() + m.getFormattedString());
            return m;
        }, OrmException::new));
        return ret;
    }

    public <T> ColumnsMapping<T> getColumnsMapping(Class<T> objectClass) {
        ColumnsMapping ret = this.columnsMappings.computeIfAbsent(objectClass, _k -> {
            ColumnsMapping m = ColumnsMapping.createMapping(this.sqlToJavaConverter, objectClass, this.fieldMapper);
            DebugPointFactory.createDebugPoint(DebugPointFactory.Name.MAPPING).ifPresent(dw -> log.debug("[{}] {}", (Object)(dw.getName() + System.lineSeparator() + m.getFormattedString())));
            return m;
        });
        return ret;
    }

    private TableName toTableName(String tableName) {
        return tableNameToValidTableNameMap.computeIfAbsent(tableName, k -> this.tableNameMapper.toValidTableName(tableName, this.connection));
    }

    private TableName toTableName(Class<?> objectClass) {
        return classNameToValidTableNameMap.computeIfAbsent(objectClass, k -> this.tableNameMapper.getTableName(objectClass, this.connection));
    }

    protected <T> TableMapping<T> getCastedTableMapping(Class<?> objectClass) {
        return this.getTableMapping(objectClass);
    }

    protected <T> TableMapping<T> getCastedTableMapping(String tableName, Class<?> objectClass) {
        return this.getTableMapping(tableName, objectClass);
    }

    @Override
    public Connection getJdbcConnection() {
        return this.connection;
    }

    @Override
    public int executeUpdate(String sql, Object ... parameters) {
        return this.execPreparedStatementWithParameters(sql, parameters, Try.createFunctionWithThrow(stmt -> stmt.executeUpdate(), OrmException::new));
    }

    @Override
    public boolean execute(String sql, Object ... parameters) {
        return this.execPreparedStatementWithParameters(sql, parameters, Try.createFunctionWithThrow(stmt -> stmt.execute(), OrmException::new));
    }

    @Override
    public ResultSet executeQuery(String sql, Object ... parameters) {
        return this.execPreparedStatementWithParameters(sql, parameters, Try.createFunctionWithThrow(stmt -> stmt.executeQuery(), OrmException::new));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <R> R execPreparedStatementWithParameters(String sql, Object[] parameters, Function<PreparedStatement, R> func) {
        try (PreparedStatement stmt = PreparedStatementUtils.getPreparedStatement(this.connection, sql);){
            this.javaToSqlConverter.setParameters(stmt, parameters);
            R r = func.apply(stmt);
            return r;
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    protected final <T> T readOneAux(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)this.execResultSet(sql, parameters, resultSet -> {
            try {
                Object ret = null;
                if (resultSet.next()) {
                    ret = this.loadOneObject(objectClass, (ResultSet)resultSet);
                }
                if (resultSet.next()) {
                    throw new OrmException("Non-unique result returned");
                }
                return ret;
            }
            catch (SQLException e) {
                throw new OrmException(e);
            }
        });
    }

    protected final <T> T readFirstAux(Class<T> objectClass, String sql, Object ... parameters) {
        return (T)this.execResultSet(sql, parameters, resultSet -> this.loadFirst(objectClass, (ResultSet)resultSet));
    }

    public <T> T loadFirst(Class<T> objectClass, ResultSet resultSet) {
        try {
            if (resultSet.next()) {
                return this.loadOneObject(objectClass, resultSet);
            }
            return null;
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    public <T> T loadOne(Class<T> objectClass, ResultSet resultSet) {
        try {
            T ret = null;
            if (resultSet.next()) {
                ret = this.loadOneObject(objectClass, resultSet);
            }
            if (resultSet.next()) {
                throw new RuntimeException("Non-unique result returned");
            }
            return ret;
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    public <T> T loadOneObject(Class<T> objectClass, ResultSet resultSet) {
        return AbstractOrmMapper.isEnableToConvertNativeSqlType(objectClass) ? this.sqlToJavaConverter.toOneNativeObject(resultSet, objectClass) : this.loadOnePojo(objectClass, resultSet);
    }

    protected final <T> T readByPrimaryKeyAux(Class<T> objectClass, Object ... primaryKeyValues) {
        TableMapping<T> mapping = this.getTableMapping(objectClass);
        String sql = mapping.getSql().getSelectByPrimaryKeySql();
        return this.readFirstAux(objectClass, sql, primaryKeyValues);
    }

    protected <T> List<T> readListAux(Class<T> objectClass, String sql, Object ... parameters) {
        return this.execResultSet(sql, parameters, resultSet -> AbstractOrmMapper.isEnableToConvertNativeSqlType(objectClass) ? this.loadNativeObjectList(objectClass, (ResultSet)resultSet) : this.loadPojoList(objectClass, (ResultSet)resultSet));
    }

    protected <T> List<T> readAllAux(Class<T> objectClass) {
        TableMapping<T> mapping = this.getTableMapping(objectClass);
        String sql = mapping.getSql().getSelectAllSql();
        Optional<DebugPoint> dp = DebugPointFactory.createDebugPoint(DebugPointFactory.Name.READ);
        List result = this.readListAux(objectClass, sql, new Object[0]);
        dp.ifPresent(sw -> log.debug("{} Read [{}] objects of [{}]", new Object[]{sw.getFormattedNameAndElapsedTime(), result.size(), objectClass.getSimpleName()}));
        return result;
    }

    <T> int deleteAllAux(Class<T> objectClass) {
        return this.getTableMapping(objectClass).deleteAll(this.connection);
    }

    <T> int deleteAllAux(String tableName, Class<T> objectClass) {
        return this.getTableMapping(tableName, objectClass).deleteAll(this.connection);
    }

    public Map<String, Object> readMap(String sql, Object ... parameters) {
        return this.execResultSet(sql, parameters, resultSet -> {
            try {
                ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
                Map<String, Object> ret = null;
                if (resultSet.next()) {
                    ret = this.sqlToJavaConverter.toOneMap((ResultSet)resultSet, ct.getColumns(), ct.getColumnTypes());
                }
                if (resultSet.next()) {
                    throw new OrmException("Non-unique result returned");
                }
                return ret;
            }
            catch (SQLException e) {
                throw new OrmException(e);
            }
        });
    }

    public Map<String, Object> readMapFirst(String sql, Object ... parameters) {
        return this.execResultSet(sql, parameters, resultSet -> {
            try {
                ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
                if (resultSet.next()) {
                    return this.sqlToJavaConverter.toOneMap((ResultSet)resultSet, ct.getColumns(), ct.getColumnTypes());
                }
                return null;
            }
            catch (SQLException e) {
                throw new OrmException(e);
            }
        });
    }

    public Map<String, Object> readMapOne(String sql, Object ... parameters) {
        return this.execResultSet(sql, parameters, resultSet -> {
            try {
                ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
                Map<String, Object> ret = null;
                if (resultSet.next()) {
                    ret = this.sqlToJavaConverter.toOneMap((ResultSet)resultSet, ct.getColumns(), ct.getColumnTypes());
                }
                if (resultSet.next()) {
                    throw new OrmException("Non-unique result returned");
                }
                return ret;
            }
            catch (SQLException e) {
                throw new OrmException(e);
            }
        });
    }

    public List<Map<String, Object>> readMapList(String sql, Object ... parameters) {
        return this.execResultSet(sql, parameters, resultSet -> this.loadMapList((ResultSet)resultSet));
    }

    public List<Map<String, Object>> loadMapList(ResultSet resultSet) {
        try {
            ArrayList<Map<String, Object>> ret = new ArrayList<Map<String, Object>>();
            ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
            while (resultSet.next()) {
                ret.add(this.sqlToJavaConverter.toOneMap(resultSet, ct.getColumns(), ct.getColumnTypes()));
            }
            return ret;
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    public final <T> LazyResultSet<T> readAllLazyAux(Class<T> objectClass) {
        return this.readLazyAux(objectClass, this.getTableMapping(objectClass).getSql().getSelectAllSql(), new Object[0]);
    }

    public final <T> LazyResultSet<T> readLazyAux(Class<T> objectClass, String sql, Object ... parameters) {
        PreparedStatement stmt = PreparedStatementUtils.getPreparedStatement(this.connection, sql);
        try {
            this.javaToSqlConverter.setParameters(stmt, parameters);
            ResultSet resultSet = stmt.executeQuery();
            return new LazyResultSet<T>(this, objectClass, stmt, resultSet);
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    public LazyResultSet<Map<String, Object>> readMapLazy(String sql, Object ... parameters) {
        PreparedStatement stmt = PreparedStatementUtils.getPreparedStatement(this.connection, sql);
        try {
            this.javaToSqlConverter.setParameters(stmt, parameters);
            ResultSet resultSet = stmt.executeQuery();
            LazyResultSet<Map<String, Object>> ret = new LazyResultSet<Map<String, Object>>(this, Map.class, stmt, resultSet);
            return ret;
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <R> R execResultSet(String sql, Object[] parameters, Function<ResultSet, R> sqlResultReader) {
        try (PreparedStatement stmt = PreparedStatementUtils.getPreparedStatement(this.connection, sql);){
            Object r;
            block14: {
                this.javaToSqlConverter.setParameters(stmt, parameters);
                ResultSet resultSet = stmt.executeQuery();
                try {
                    Optional<DebugPoint> dp = DebugPointFactory.createDebugPoint(DebugPointFactory.Name.READ);
                    dp.ifPresent(sw -> log.debug("[{}] with {} ", (Object)sql, (Object)parameters));
                    Object ret = sqlResultReader.apply(resultSet);
                    dp.ifPresent(sw -> log.debug("{} Read [{}] objects from [{}]", new Object[]{sw.getFormattedNameAndElapsedTime(), ret instanceof Collection ? ((Collection)ret).size() : 1, Try.getOrNull(() -> this.connection.getMetaData().getURL())}));
                    r = ret;
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return r;
        }
        catch (Exception e) {
            throw new OrmException(StringUtils.format("Error in [{}] with {}", sql, parameters), e);
        }
    }

    private <T> List<T> loadNativeObjectList(Class<T> objectClass, ResultSet resultSet) {
        try {
            Optional<DebugPoint> dp = DebugPointFactory.createDebugPoint(DebugPointFactory.Name.LOAD_OBJECT);
            ArrayList<T> ret = new ArrayList<T>();
            while (resultSet.next()) {
                ret.add(this.sqlToJavaConverter.toOneNativeObject(resultSet, objectClass));
            }
            dp.ifPresent(sw -> {
                try {
                    ResultSetMetaData metaData = resultSet.getMetaData();
                    if (metaData.getColumnCount() != 1) {
                        throw new OrmException("ResultSet returned [" + metaData.getColumnCount() + "] columns but 1 column was expected to load data into an instance of [" + objectClass.getName() + "]");
                    }
                }
                catch (SQLException e) {
                    throw new OrmException(e);
                }
            });
            return ret;
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    public final <T> List<T> loadPojoList(Class<T> objectClass, ResultSet resultSet) {
        ColumnsMapping<T> mapping = this.getColumnsMapping(objectClass);
        return mapping.createObjectList(resultSet);
    }

    private final <T> T loadOnePojo(Class<T> objectClass, ResultSet resultSet) {
        ColumnsMapping<T> mapping = this.getColumnsMapping(objectClass);
        return mapping.createObject(resultSet);
    }

    public Map<String, Object> loadOneMap(ResultSet resultSet) {
        ColumnsAndTypes ct = AbstractOrmMapper.createColumnsAndTypes(resultSet);
        return this.sqlToJavaConverter.toOneMap(resultSet, ct.getColumns(), ct.getColumnTypes());
    }

    protected final <T, R> R execSqlIfParameterExists(T[] objects, Function<TableMapping<T>, R> sqlFunction, Supplier<R> notExists) {
        if (objects == null || objects.length == 0) {
            return notExists.get();
        }
        TableMapping<T> mapping = this.getCastedTableMapping(objects[0].getClass());
        return sqlFunction.apply(mapping);
    }

    protected final <T, R> R execSqlIfParameterExists(T[] objects, String tableName, Function<TableMapping<T>, R> sqlFunction, Supplier<R> notExists) {
        if (objects == null || objects.length == 0) {
            return notExists.get();
        }
        TableMapping<T> mapping = this.getCastedTableMapping(tableName, objects[0].getClass());
        return sqlFunction.apply(mapping);
    }

    private static ColumnsAndTypes createColumnsAndTypes(ResultSet resultSet) {
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int colNum = metaData.getColumnCount();
            ArrayList<String> columns = new ArrayList<String>(colNum);
            ArrayList<Integer> columnTypes = new ArrayList<Integer>(colNum);
            for (int i = 1; i <= colNum; ++i) {
                columns.add(metaData.getColumnName(i));
                columnTypes.add(metaData.getColumnType(i));
            }
            return new ColumnsAndTypes(columns, columnTypes);
        }
        catch (SQLException e) {
            throw new OrmException(e);
        }
    }

    private static boolean isEnableToConvertNativeSqlType(Class<?> type) {
        return nativeSqlTypes.contains(type);
    }

    protected OrmConfigStore getConfigStore() {
        return this.configStore;
    }

    <T> List<String> getAllColumnsAux(Class<T> objectClass) {
        return this.getTableMapping(objectClass).getAllColumns();
    }

    <T> List<String> getPrimaryKeysAux(Class<T> objectClass) {
        return this.getTableMapping(objectClass).getPrimaryKeys();
    }

    private static class ColumnsAndTypes {
        private final List<String> columns;
        private final List<Integer> columnTypes;

        public ColumnsAndTypes(List<String> columns, List<Integer> columnTypes) {
            this.columns = columns;
            this.columnTypes = columnTypes;
        }

        public List<String> getColumns() {
            return this.columns;
        }

        public List<Integer> getColumnTypes() {
            return this.columnTypes;
        }
    }
}

