/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.mapping.Column;
import org.nkjmlab.sorm4j.util.StringUtils;

final class Accessor {
    private final GetterAccessor getter;
    private final SetterAccessor setter;
    private final Column column;

    Accessor(Column column, Field field, Method getter, Method setter) {
        this.column = column;
        this.getter = getter != null ? new GetterMethod(getter) : new FieldGetter(field);
        this.setter = setter != null ? new SetterMethod(setter) : new FieldSetter(field);
    }

    public SetterAccessor getSetter() {
        return this.setter;
    }

    public Object get(Object object) {
        return this.getter.get(object);
    }

    public void set(Object object, Object value) {
        this.setter.set(object, value);
    }

    public String toString() {
        return "Accessor [getterAccessor=" + this.getter + ", setterAccessor=" + this.setter + ", column=" + this.column + "]";
    }

    public String getFormattedString() {
        return "getter=[" + this.getter + "], setter=[" + this.setter + "]";
    }

    public Class<?> getSetterParameterType() {
        return this.setter.getParameterType();
    }

    private class FieldSetter
    implements SetterAccessor {
        private Field field;

        public FieldSetter(Field field) {
            this.field = field;
        }

        @Override
        public Class<?> getParameterType() {
            Class<?> type = this.field.getType();
            return type;
        }

        @Override
        public void set(Object object, Object value) {
            try {
                this.field.set(object, value);
            }
            catch (Exception e) {
                throw new OrmException(StringUtils.format("Error setting value [{}] of type [{}] from column [{}] using field [{}]: {}", value, value.getClass().getName(), Accessor.this.column, this.field, e.getMessage(), e));
            }
        }

        public String toString() {
            return "field " + this.field.getType().getSimpleName() + " " + this.field.getName();
        }
    }

    private class SetterMethod
    implements SetterAccessor {
        private final Method setter;

        public SetterMethod(Method setter) {
            this.setter = setter;
        }

        @Override
        public Class<?> getParameterType() {
            Class<?> type = this.setter.getParameterTypes()[0];
            return type;
        }

        @Override
        public void set(Object object, Object value) {
            try {
                this.setter.invoke(object, value);
            }
            catch (Exception e) {
                throw new OrmException(StringUtils.format("Error setting value [{} ({})] from column [{}] using setter [{}]: {}", value, value.getClass().getName(), Accessor.this.column, this.toString(), e.getMessage(), e));
            }
        }

        public String toString() {
            return this.setter.getName() + "(" + this.setter.getParameterTypes()[0].getSimpleName() + ")";
        }
    }

    private static interface SetterAccessor {
        public void set(Object var1, Object var2);

        public Class<?> getParameterType();
    }

    private class FieldGetter
    implements GetterAccessor {
        private final Field field;

        public FieldGetter(Field field) {
            this.field = field;
        }

        @Override
        public Object get(Object object) {
            try {
                return this.field.get(object);
            }
            catch (Exception e) {
                throw new OrmException(StringUtils.format("Could not access field for column [{}] with [{}]", Accessor.this.column, this), e);
            }
        }

        public String toString() {
            return "field " + this.field.getType().getSimpleName() + " " + this.field.getName();
        }
    }

    private class GetterMethod
    implements GetterAccessor {
        private final Method getter;

        public GetterMethod(Method getter) {
            this.getter = getter;
        }

        @Override
        public Object get(Object object) {
            try {
                return this.getter.invoke(object, new Object[0]);
            }
            catch (Exception e) {
                throw new OrmException("Could not access getter for column [" + Accessor.this.column + "]", e);
            }
        }

        public String toString() {
            return this.getter.getReturnType().getSimpleName() + " " + this.getter.getName() + "()";
        }
    }

    private static interface GetterAccessor {
        public Object get(Object var1);
    }
}

