/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.config.ColumnFieldMapper;
import org.nkjmlab.sorm4j.mapping.Mapping;
import org.nkjmlab.sorm4j.mapping.ResultSetConverter;
import org.nkjmlab.sorm4j.util.Try;

public final class ColumnsMapping<T>
extends Mapping<T> {
    private final Constructor<T> constructor = Try.createSupplierWithThrow(() -> objectClass.getDeclaredConstructor(new Class[0]), OrmException::new).get();
    private static final Map<List<String>, List<Class<?>>> setterParamTypesMap = new ConcurrentHashMap();

    public ColumnsMapping(ResultSetConverter sqlToJava, Class<T> objectClass, ColumnFieldMapper nameGuesser) {
        super(sqlToJava, objectClass, nameGuesser);
        this.constructor.setAccessible(true);
    }

    public static <T> ColumnsMapping<T> createMapping(ResultSetConverter converter, Class<T> objectClass, ColumnFieldMapper nameGuesser) {
        return new ColumnsMapping<T>(converter, objectClass, nameGuesser);
    }

    @Override
    public String toString() {
        return "ColumnsMapping [" + super.toString() + "]";
    }

    public String getFormattedString() {
        return "Columns are mappted to class. " + System.lineSeparator() + super.getColumnToAccessorString();
    }

    public T createObject(ResultSet resultSet) {
        List<String> columns = ColumnsMapping.createColumns(resultSet);
        List<Class<?>> setterParamTypes = this.getSetterParamTypes(columns);
        return this.createObject(columns, this.sqlToJavaConverter.toObjectsByClasses(resultSet, setterParamTypes));
    }

    public List<T> createObjectList(ResultSet resultSet) {
        try {
            List<String> columns = ColumnsMapping.createColumns(resultSet);
            List<Class<?>> setterParamTypes = this.getSetterParamTypes(columns);
            ArrayList<T> ret = new ArrayList<T>();
            while (resultSet.next()) {
                ret.add(this.createObject(columns, this.sqlToJavaConverter.toObjectsByClasses(resultSet, setterParamTypes)));
            }
            return ret;
        }
        catch (IllegalArgumentException | SecurityException | SQLException e) {
            throw new OrmException(e);
        }
    }

    private T createObject(List<String> columns, List<Object> values) {
        try {
            T ret = this.constructor.newInstance(new Object[0]);
            for (int i = 0; i < columns.size(); ++i) {
                String columnName = columns.get(i);
                Object value = values.get(i);
                this.setValue(ret, columnName, value);
            }
            return ret;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new OrmException(e);
        }
    }

    private static List<String> createColumns(ResultSet resultSet) {
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int colNum = metaData.getColumnCount();
            ArrayList<String> columns = new ArrayList<String>(colNum);
            for (int i = 1; i <= colNum; ++i) {
                columns.add(metaData.getColumnName(i));
            }
            return columns;
        }
        catch (IllegalArgumentException | SecurityException | SQLException e) {
            throw new OrmException(e);
        }
    }

    private List<Class<?>> getSetterParamTypes(List<String> columns) {
        return setterParamTypesMap.computeIfAbsent(columns, k -> columns.stream().map(c -> this.columnToAccessorMap.get((String)c).getSetterParameterType()).collect(Collectors.toList()));
    }
}

