/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.config.ColumnFieldMapper;
import org.nkjmlab.sorm4j.mapping.Accessor;
import org.nkjmlab.sorm4j.mapping.Column;
import org.nkjmlab.sorm4j.mapping.ColumnToAccessorMap;
import org.nkjmlab.sorm4j.mapping.FieldName;
import org.nkjmlab.sorm4j.mapping.ResultSetConverter;
import org.nkjmlab.sorm4j.util.LoggerFactory;
import org.nkjmlab.sorm4j.util.StringUtils;
import org.slf4j.Logger;

abstract class Mapping<T> {
    private static final Logger log = LoggerFactory.getLogger();
    protected final ResultSetConverter sqlToJavaConverter;
    protected final Class<T> objectClass;
    protected final ColumnToAccessorMap columnToAccessorMap;

    public Mapping(ResultSetConverter sqlToJavaConverter, Class<T> objectClass, ColumnFieldMapper nameGuesser) {
        this(sqlToJavaConverter, objectClass, Mapping.guessColumnNames(objectClass, nameGuesser), nameGuesser);
    }

    private static List<Column> guessColumnNames(Class<?> objectClass, ColumnFieldMapper nameGuesser) {
        HashSet<FieldName> names = new HashSet<FieldName>();
        names.addAll(Mapping.getAllFields(objectClass).keySet());
        names.addAll(Mapping.getAllGetters(objectClass).keySet());
        names.addAll(Mapping.getAllSetters(objectClass).keySet());
        List<Column> columns = nameGuesser.getColumnNameCandidates(new ArrayList<FieldName>(names));
        columns.addAll(nameGuesser.getAnnotatedFieldsMap(objectClass).keySet());
        columns.addAll(nameGuesser.getAnnotatedGettersMap(objectClass).keySet());
        columns.addAll(nameGuesser.getAnnotatatedSettersMap(objectClass).keySet());
        return columns;
    }

    public Mapping(ResultSetConverter sqlToJavaConverter, Class<T> objectClass, List<Column> columns, ColumnFieldMapper nameGuesser) {
        this.sqlToJavaConverter = sqlToJavaConverter;
        this.objectClass = objectClass;
        this.columnToAccessorMap = new ColumnToAccessorMap(this.createAccessors(columns, nameGuesser));
    }

    protected Map<String, Accessor> createAccessors(List<Column> columns, ColumnFieldMapper nameGuesser) {
        Map<FieldName, Field> fields = Mapping.getAllFields(this.objectClass);
        Map<FieldName, Method> getters = Mapping.getAllGetters(this.objectClass);
        Map<FieldName, Method> setters = Mapping.getAllSetters(this.objectClass);
        Map<Column, Field> annotatedFields = nameGuesser.getAnnotatedFieldsMap(this.objectClass);
        Map<Column, Method> annotatedGetters = nameGuesser.getAnnotatedGettersMap(this.objectClass);
        Map<Column, Method> annotatedSetters = nameGuesser.getAnnotatatedSettersMap(this.objectClass);
        ArrayList<FieldName> fieldsList = new ArrayList<FieldName>(fields.keySet());
        HashMap<String, Accessor> ret = new HashMap<String, Accessor>();
        for (Column column : columns) {
            Field f = annotatedFields.get(column);
            Method g = Mapping.isValidGetter(annotatedGetters.get(column));
            Method s = Mapping.isValidSetter(annotatedSetters.get(column));
            Optional<FieldName> op = nameGuesser.getFieldNameByColumnName(column, fieldsList);
            if (op.isPresent()) {
                FieldName fieldName = op.get();
                f = f != null ? f : fields.get(fieldName);
                g = g != null ? g : Mapping.isValidGetter(getters.get(fieldName));
                Method method = s = s != null ? g : Mapping.isValidSetter(setters.get(fieldName));
            }
            if (f == null && (g == null || s == null)) {
                log.debug("Skip matching with Column [{}] to field because could not found corresponding field.", (Object)column);
                continue;
            }
            ret.put(column.getName(), new Accessor(column, f, g, s));
        }
        return ret;
    }

    private static Method isValidSetter(Method setter) {
        if (setter == null) {
            return null;
        }
        if (setter.getParameterCount() != 1) {
            log.warn("Setter [{}] should have a single parameter but has {} params.", (Object)setter, (Object)setter.getParameterCount());
            return null;
        }
        return setter;
    }

    private static Method isValidGetter(Method getter) {
        if (getter == null) {
            return null;
        }
        if (getter.getParameterCount() != 0) {
            log.warn("Getter [{}] should not have parameter but has {} params.", (Object)getter, (Object)getter.getParameterCount());
            return null;
        }
        if (getter.getReturnType() == Void.TYPE) {
            log.warn("Getter [{}] must have return a parameter.");
        }
        return getter;
    }

    public static Map<FieldName, Field> getAllFields(Class<?> objectClass) {
        return Arrays.stream(objectClass.getDeclaredFields()).collect(Collectors.toMap(f -> new FieldName((Field)f), f -> {
            f.setAccessible(true);
            return f;
        }));
    }

    private static Map<FieldName, Method> getAllSetters(Class<?> objectClass) {
        Map<FieldName, Method> setters = Mapping.extractedMethodStartWith(objectClass, "set");
        return setters;
    }

    private static Map<FieldName, Method> getAllGetters(Class<?> objectClass) {
        Map<FieldName, Method> getters = Mapping.extractedMethodStartWith(objectClass, "get");
        return getters;
    }

    private static Map<FieldName, Method> extractedMethodStartWith(Class<?> objectClass, String prefix) {
        return Arrays.stream(objectClass.getDeclaredMethods()).filter(m -> m.getName().substring(0, prefix.length()).equals(prefix)).collect(Collectors.toMap(m -> new FieldName(m.getName().substring(prefix.length(), prefix.length() + 1).toLowerCase() + m.getName().substring(prefix.length() + 1)), m -> m));
    }

    final Object getValue(Object object, String columnName) {
        Accessor acc = this.columnToAccessorMap.get(columnName);
        if (acc != null) {
            return acc.get(object);
        }
        throw new OrmException(StringUtils.format("Error getting value from [{}] because column [{}] does not have a corresponding setter method or field", object.getClass(), columnName));
    }

    final void setValue(Object object, String columnName, Object value) {
        Accessor acc = this.columnToAccessorMap.get(columnName);
        if (acc == null) {
            throw new OrmException(StringUtils.format("Error setting value [{}] of type [{}] in [{}] because column [{}] does not have a corresponding setter method or field =>[{}]", value, value.getClass().getName(), object.getClass().getName(), columnName, this.columnToAccessorMap.keySet()));
        }
        acc.set(object, value);
    }

    public String toString() {
        return "Mapping [objectClass=" + this.objectClass.getName() + ", columnToAccessorMap=" + this.columnToAccessorMap.values() + "]";
    }

    protected String getColumnToAccessorString() {
        List columnStrs = this.columnToAccessorMap.keySet().stream().sorted().collect(Collectors.toList());
        return "COLUMNS " + columnStrs + " is mapped to [" + this.objectClass.getName() + "]" + System.lineSeparator() + String.join((CharSequence)System.lineSeparator(), columnStrs.stream().map(e -> "  COLUM " + e + " => " + this.columnToAccessorMap.get((String)e).getFormattedString()).collect(Collectors.toList()));
    }
}

