/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.mapping.MultiRowProcessor;
import org.nkjmlab.sorm4j.mapping.TableMapping;
import org.nkjmlab.sorm4j.util.ArrayUtils;
import org.nkjmlab.sorm4j.util.PreparedStatementUtils;

public final class MultiRowInOneStatementProcessor<T>
extends MultiRowProcessor<T> {
    private final int multiRowSize;

    public MultiRowInOneStatementProcessor(TableMapping<T> tableMapping, int batchSize, int multiRowSize) {
        super(tableMapping, batchSize);
        this.multiRowSize = multiRowSize;
    }

    @Override
    public int[] multiRowInsert(Connection con, T ... objects) {
        return this.execIfValidObjects(con, objects, nonNullObjects -> this.procMultiRowOneStatement(con, num -> PreparedStatementUtils.getPreparedStatement(con, this.tableMapping.getSql().getMultirowInsertSql((int)num)), (stmt, objs) -> this.tableMapping.setPrameters((PreparedStatement)stmt, objs), (T[])nonNullObjects));
    }

    @Override
    public int[] multiRowMerge(Connection con, T ... objects) {
        return this.execIfValidObjects(con, objects, nonNullObjects -> this.procMultiRowOneStatement(con, num -> PreparedStatementUtils.getPreparedStatement(con, this.tableMapping.getSql().getMultirowMergeSql((int)num)), (stmt, objs) -> this.tableMapping.setPrameters((PreparedStatement)stmt, objs), (T[])nonNullObjects));
    }

    private final int[] procMultiRowOneStatement(Connection con, Function<Integer, PreparedStatement> multiRowStatementCreator, BiConsumer<PreparedStatement, T[]> parametersSetter, T[] objects) {
        List<T[]> objsPartitions = ArrayUtils.split(this.multiRowSize, objects);
        int[] result = new int[objsPartitions.size()];
        boolean origAutoCommit = this.getAutoCommit(con);
        try {
            int[] nArray;
            block19: {
                this.setAutoCommit(con, false);
                try (PreparedStatement stmt = multiRowStatementCreator.apply(this.multiRowSize);){
                    for (int partitionNum = 0; partitionNum < objsPartitions.size() - 1; ++partitionNum) {
                        T[] objectsInOnePartition = objsPartitions.get(partitionNum);
                        parametersSetter.accept(stmt, objectsInOnePartition);
                        result[partitionNum] = stmt.executeUpdate();
                    }
                }
                int lastPartition = objsPartitions.size() - 1;
                T[] objectsInLastPartition = objsPartitions.get(lastPartition);
                PreparedStatement stmt = multiRowStatementCreator.apply(objectsInLastPartition.length);
                try {
                    parametersSetter.accept(stmt, objectsInLastPartition);
                    result[lastPartition] = stmt.executeUpdate();
                    nArray = result;
                    if (stmt == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.rollbackIfRequired(con, origAutoCommit);
                        throw new OrmException(e);
                    }
                }
                stmt.close();
            }
            return nArray;
        }
        finally {
            this.commitIfRequired(con, origAutoCommit);
            this.setAutoCommit(con, origAutoCommit);
        }
    }
}

