/*
 * Decompiled with CFR 0.152.
 */
package org.nkjmlab.sorm4j.mapping;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import org.nkjmlab.sorm4j.OrmException;
import org.nkjmlab.sorm4j.mapping.BatchHelper;
import org.nkjmlab.sorm4j.mapping.TableMapping;
import org.nkjmlab.sorm4j.util.DebugPoint;
import org.nkjmlab.sorm4j.util.DebugPointFactory;
import org.nkjmlab.sorm4j.util.LoggerFactory;
import org.nkjmlab.sorm4j.util.PreparedStatementUtils;
import org.nkjmlab.sorm4j.util.Try;
import org.slf4j.Logger;

public abstract class MultiRowProcessor<T> {
    private static final Logger log = LoggerFactory.getLogger();
    final TableMapping<T> tableMapping;
    private final int batchSize;

    MultiRowProcessor(TableMapping<T> tableMapping, int batchSize) {
        this.tableMapping = tableMapping;
        this.batchSize = batchSize;
    }

    public abstract int[] multiRowInsert(Connection var1, T ... var2);

    public abstract int[] multiRowMerge(Connection var1, T ... var2);

    void setAutoCommit(Connection connection, boolean autoCommit) {
        Try.runOrThrow(() -> connection.setAutoCommit(autoCommit), OrmException::new);
    }

    void commitIfRequired(Connection connection, boolean origAutoCommit) {
        if (origAutoCommit) {
            Try.runOrThrow(() -> connection.commit(), OrmException::new);
        }
    }

    void rollbackIfRequired(Connection connection, boolean origAutoCommit) {
        if (!origAutoCommit) {
            Try.runOrThrow(() -> connection.rollback(), OrmException::new);
        }
    }

    boolean getAutoCommit(Connection connection) {
        return Try.createSupplierWithThrow(() -> connection.getAutoCommit(), OrmException::new).get();
    }

    public int[] batch(Connection con, String sql, Function<T, Object[]> parameterCreator, T[] objects) {
        return this.execIfValidObjects(con, objects, nonNullObjects -> this.batchAux(con, sql, obj -> (Object[])parameterCreator.apply(obj), (T[])nonNullObjects));
    }

    private int[] batchAux(Connection con, String sql, Function<T, Object[]> parameterCreator, T[] objects) {
        int[] result = new int[]{};
        boolean origAutoCommit = this.getAutoCommit(con);
        try {
            int[] nArray;
            block12: {
                PreparedStatement stmt = PreparedStatementUtils.getPreparedStatement(con, sql);
                try {
                    this.setAutoCommit(con, false);
                    BatchHelper batchHelper = new BatchHelper(this.batchSize, stmt);
                    for (int i = 0; i < objects.length; ++i) {
                        T obj = objects[i];
                        this.tableMapping.javaToSqlConverter.setParameters(stmt, parameterCreator.apply(obj));
                        batchHelper.addBatchAndExecuteIfReachedThreshold();
                    }
                    nArray = result = batchHelper.finish();
                    if (stmt == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        this.rollbackIfRequired(con, origAutoCommit);
                        throw new OrmException(e);
                    }
                }
                stmt.close();
            }
            return nArray;
        }
        finally {
            this.commitIfRequired(con, origAutoCommit);
            this.setAutoCommit(con, origAutoCommit);
        }
    }

    int[] execIfValidObjects(Connection con, T[] objects, Function<T[], int[]> exec) {
        if (objects == null || objects.length == 0) {
            return new int[0];
        }
        Optional<DebugPoint> dp = DebugPointFactory.createDebugPoint(DebugPointFactory.Name.EXECUTE_BATCH);
        A[] nonNullObjects = Arrays.stream(objects).filter(Objects::nonNull).toArray(Object[]::new);
        int[] result = exec.apply(nonNullObjects);
        dp.ifPresent(sw -> log.debug("{} [{}] objects (req=[{}]) of [{}] are wrote into [{}]  at [{}]", new Object[]{sw.getFormattedNameAndElapsedTime(), IntStream.of(result).sum(), objects.length, this.tableMapping.objectClass, this.tableMapping.getTableName(), Try.getOrNull(() -> con.getMetaData().getURL())}));
        return result;
    }
}

